package org.lsst.ccs.gconsole.agent;

import java.util.*;
import org.lsst.ccs.Agent;

/**
 * Dictionary of data channels published by an {@link Agent}.
 * Constructed and maintained by {@link AgentStatusAggregator}.
 * <i>
 * TEMPORARY implementation: review once Agents are taught how to publish real dictionaries.
 *
 * @author onoprien
 */
class AgentChannelsDictionary {

// -- Fields : -----------------------------------------------------------------
    
    private final List<MutableAgentChannel> channels;


// -- Life cycle : -------------------------------------------------------------
    
    AgentChannelsDictionary(List<MutableAgentChannel> channels) {
        this.channels = Collections.unmodifiableList(channels);
    }

// -- Getters : ----------------------------------------------------------------
        
    MutableAgentChannel get(String innerPath) {
        for (MutableAgentChannel chan : channels) {
            if (chan.getLocalPath().equals(innerPath)) {
                return chan;
            }
        }
        return null;
    }
    
    List<MutableAgentChannel> getAll() {
        return channels;
    }

}
