/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.Transient;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.lsst.ccs.gconsole.agent.AgentChannel;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.gconsole.annotations.ConsoleLookup;
import org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView;
import org.lsst.ccs.gconsole.plugins.monitor.LsstMonitorPlugin;
import org.lsst.ccs.gconsole.plugins.monitor.MeshTable;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorTable;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorView;
import org.lsst.ccs.gconsole.plugins.monitor.SectionedTable;
import org.lsst.ccs.subsystem.monitor.ui.tree.MonitorDisplay;

@ConsoleLookup(id="org.lsst.ccs.gconsole.plugins.monitor.MonitorView", name="Tree View", path="Built-In/Tree", description="Monitoring data view that displays its data in a tree of tables.")
public class TreeView
extends AbstractMonitorView {
    private final InterNode root;
    DefaultTreeModel treeModel;
    private final Tree tree;
    private final JScrollPane scrollPane;
    private List<MonitorField> fields = Arrays.asList(MonitorField.NAME, MonitorField.VALUE, MonitorField.UNITS, MonitorField.LOW, MonitorField.ALERT_LOW, MonitorField.HIGH, MonitorField.ALERT_HIGH, MonitorField.DESCR);
    private List<MonitorField> compactFields = Arrays.asList(MonitorField.NAME, MonitorField.VALUE);

    public TreeView() {
        this.root = new InterNode("");
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree = new Tree(this.treeModel);
        this.scrollPane = new JScrollPane(this.tree);
        this.descriptor = new Descriptor();
        this.root.init(Collections.emptyList());
    }

    @Override
    protected void resetChannels() {
        this.updateDescriptor(this.root);
        this.root.clear();
        this.root.init(this.path2data.entrySet());
        this.treeModel.reload();
        this.root.restoreExpansion();
    }

    @Override
    public JComponent getPanel() {
        return this.scrollPane;
    }

    @Override
    public void setFilter(AgentChannelsFilter filter) {
        super.setFilter(filter);
        List<String> ff = filter.getFields(true);
        if (ff != null) {
            this.compactFields = new ArrayList<MonitorField>(ff.size());
            for (String field : ff) {
                this.compactFields.add(MonitorField.getInstance(field));
            }
        }
        if ((ff = filter.getFields(false)) != null) {
            this.fields = new ArrayList<MonitorField>(ff.size());
            for (String field : ff) {
                this.fields.add(MonitorField.getInstance(field));
            }
        }
    }

    @Override
    public Descriptor save() {
        this.getDescriptor().setNodes(null);
        this.updateDescriptor(this.root);
        return this.getDescriptor();
    }

    @Override
    public void restore(MonitorView.Descriptor descriptor) {
        if (descriptor instanceof Descriptor) {
            this.descriptor = (Descriptor)descriptor;
        }
    }

    @Override
    protected Descriptor getDescriptor() {
        return (Descriptor)this.descriptor;
    }

    private void updateDescriptor(Node node) {
        TreeMap<String, Serializable> nodes = this.getDescriptor().getNodes();
        if (nodes == null) {
            nodes = new TreeMap();
            this.getDescriptor().setNodes(nodes);
        }
        String path = node == this.root ? "" : node.getPathString() + "/";
        Enumeration<TreeNode> en = node.children();
        while (en.hasMoreElements()) {
            this.updateDescriptor((Node)en.nextElement(), path, nodes);
        }
    }

    private void updateDescriptor(Node node, String path, TreeMap<String, Serializable> map) {
        Serializable desc = node.save();
        path = path + node.toString();
        map.put(path, desc);
        path = path + "/";
        Enumeration<TreeNode> en = node.children();
        while (en.hasMoreElements()) {
            this.updateDescriptor((Node)en.nextElement(), path, map);
        }
    }

    public static class Descriptor
    extends AbstractMonitorView.Descriptor {
        private TreeMap<String, Serializable> nodes;

        public TreeMap<String, Serializable> getNodes() {
            return this.nodes;
        }

        public void setNodes(TreeMap<String, Serializable> nodes) {
            this.nodes = nodes;
        }
    }

    protected class MonitorTableNode
    extends DisplayNode {
        private final MonitorTable model;
        private final JPanel renderPanel;
        private final JPanel editPanel;

        MonitorTableNode(MonitorTable tableModel) {
            this(tableModel, tableModel.getClass().getName());
        }

        MonitorTableNode(MonitorTable tableModel, String name) {
            super(name);
            this.model = tableModel;
            JTable table = this.model.getTable();
            this.renderPanel = new JPanel(new BorderLayout());
            this.renderPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0), BorderFactory.createLineBorder(Color.BLACK)));
            if (this.model.showHeader()) {
                this.renderPanel.add((Component)table.getTableHeader(), "North");
            }
            this.renderPanel.add((Component)table, "Center");
            table = this.model.getTable();
            this.editPanel = new JPanel(new BorderLayout());
            this.editPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0), BorderFactory.createLineBorder(Color.BLACK)));
            if (this.model.showHeader()) {
                this.editPanel.add((Component)table.getTableHeader(), "North");
            }
            this.editPanel.add((Component)table, "Center");
        }

        @Override
        JComponent getRendererComponent() {
            return this.renderPanel;
        }

        @Override
        JComponent getEditorComponent() {
            return this.editPanel;
        }

        @Override
        void clear() {
            this.model.destroy();
            super.clear();
        }

        @Override
        Serializable save() {
            return this.model.save();
        }
    }

    protected abstract class DisplayNode
    extends Node
    implements ChangeListener {
        DisplayNode() {
            super("display");
        }

        DisplayNode(String name) {
            super(name);
        }

        abstract JComponent getRendererComponent();

        abstract JComponent getEditorComponent();

        @Override
        public void stateChanged(ChangeEvent e) {
            if (this.parent == null) {
                return;
            }
            TreeView.this.treeModel.nodeChanged(this);
        }
    }

    public static class InterNodeDescriptor
    implements Serializable {
        static final int FLAT = 1;
        static final int MESH = 2;
        static final int FLIP = 4;
        static final int COMPACT = 8;
        static final int SECTION = 16;
        static final int EXPANDED = 32;
        private int flags;

        public InterNodeDescriptor() {
        }

        public InterNodeDescriptor(InterNodeDescriptor other) {
            this.flags = other.flags;
        }

        public int getFlags() {
            return this.flags;
        }

        @Transient
        public DisplayMode getDisplayMode() {
            if (this.isFlat()) {
                return DisplayMode.FLAT;
            }
            if (this.isMesh()) {
                return this.isFlip() ? DisplayMode.FLIPPED_MESH : DisplayMode.MESH;
            }
            return DisplayMode.TREE;
        }

        @Transient
        public boolean isFlat() {
            return (this.flags & 1) > 0;
        }

        @Transient
        public boolean isMesh() {
            return (this.flags & 2) > 0;
        }

        @Transient
        public boolean isFlip() {
            return (this.flags & 4) > 0;
        }

        @Transient
        public boolean isCompact() {
            return (this.flags & 8) > 0;
        }

        @Transient
        public boolean isSection() {
            return (this.flags & 0x10) > 0;
        }

        @Transient
        public boolean isExpanded() {
            return (this.flags & 0x20) > 0;
        }

        public void setFlags(int flags) {
            this.flags = flags;
        }

        @Transient
        public void setDisplayMode(DisplayMode value) {
            switch (value) {
                case TREE: {
                    this.setFlat(false);
                    this.setMesh(false);
                    this.setFlip(false);
                    break;
                }
                case FLAT: {
                    this.setFlat(true);
                    this.setMesh(false);
                    this.setFlip(false);
                    break;
                }
                case MESH: {
                    this.setFlat(false);
                    this.setMesh(true);
                    this.setFlip(false);
                    break;
                }
                case FLIPPED_MESH: {
                    this.setFlat(false);
                    this.setMesh(true);
                    this.setFlip(true);
                }
            }
        }

        public void setFlat(boolean value) {
            this.setBits(value, 1);
        }

        public void setMesh(boolean value) {
            this.setBits(value, 2);
        }

        public void setFlip(boolean value) {
            this.setBits(value, 4);
        }

        public void setCompact(boolean value) {
            this.setBits(value, 8);
        }

        public void setSection(boolean value) {
            this.setBits(value, 16);
        }

        public void setExpanded(boolean value) {
            this.setBits(value, 32);
        }

        private void setBits(boolean value, int mask) {
            this.flags = value ? (this.flags |= mask) : (this.flags &= ~mask);
        }

        public static enum DisplayMode {
            TREE,
            FLAT,
            MESH,
            FLIPPED_MESH;

        }
    }

    private class InterNode
    extends Node {
        private InterNodeDescriptor desc;
        private Collection<Map.Entry<String, AbstractMonitorView.ChannelHandle>> data;

        InterNode(String name) {
            super(name);
        }

        /*
         * WARNING - void declaration
         */
        void init(Collection<Map.Entry<String, AbstractMonitorView.ChannelHandle>> data) {
            ArrayList<Map.Entry<String, AbstractMonitorView.ChannelHandle>> processedData;
            TreeMap<String, Serializable> nodes;
            this.data = data;
            if (this.desc == null) {
                String pathKey = this.getPathString();
                nodes = TreeView.this.getDescriptor().getNodes();
                Serializable serializable = nodes == null ? null : nodes.get(pathKey);
                this.desc = serializable == null || !(serializable instanceof InterNodeDescriptor) ? new InterNodeDescriptor() : (InterNodeDescriptor)serializable;
            }
            if (this.desc.isSection()) {
                processedData = new ArrayList(data.size());
                for (Map.Entry entry : data) {
                    String processedKey = ((String)entry.getKey()).replaceFirst("/+", "//");
                    processedData.add(new AbstractMap.SimpleImmutableEntry(processedKey, entry.getValue()));
                }
            } else {
                processedData = new ArrayList<Map.Entry<String, AbstractMonitorView.ChannelHandle>>(data);
            }
            if (this.desc.isFlat()) {
                void var4_9;
                nodes = TreeView.this.getDescriptor().getNodes();
                String string = this.getPathString();
                if (!string.isEmpty()) {
                    String string2 = string + "/";
                }
                String string3 = (String)var4_9 + SectionedTable.class.getName();
                Serializable disDesc = nodes == null ? null : nodes.get(string3);
                SectionedTable.Descriptor descriptor = !(disDesc instanceof SectionedTable.Descriptor) ? null : (SectionedTable.Descriptor)disDesc;
                SectionedTable sectionedTable = SectionedTable.getInstance(processedData, this.desc.isCompact() ? TreeView.this.compactFields : TreeView.this.fields, descriptor);
                MonitorTableNode dNode = new MonitorTableNode(sectionedTable);
                sectionedTable.setChangeListener(dNode);
                this.add(dNode);
            } else {
                MonitorTable tableModel;
                ArrayList<Map.Entry<String, AbstractMonitorView.ChannelHandle>> leaves = new ArrayList<Map.Entry<String, AbstractMonitorView.ChannelHandle>>(processedData.size());
                ArrayList<Map.Entry<String, AbstractMonitorView.ChannelHandle>> arrayList = new ArrayList<Map.Entry<String, AbstractMonitorView.ChannelHandle>>(processedData.size());
                LinkedHashMap branches = new LinkedHashMap();
                for (Map.Entry<String, AbstractMonitorView.ChannelHandle> entry : processedData) {
                    String[] pathSegments = entry.getKey().split("/+");
                    if (pathSegments.length == 1) {
                        leaves.add(entry);
                        continue;
                    }
                    if (this.desc.isMesh() && (pathSegments.length == 2 || pathSegments.length == 3)) {
                        void var7_16;
                        if (this.desc.isFlip()) {
                            String dp = pathSegments.length == 2 ? pathSegments[1] + "/" + pathSegments[0] : pathSegments[0] + "/" + pathSegments[2] + "/" + pathSegments[1];
                            AbstractMap.SimpleImmutableEntry<String, AbstractMonitorView.ChannelHandle> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<String, AbstractMonitorView.ChannelHandle>(dp, entry.getValue());
                        }
                        arrayList.add((Map.Entry<String, AbstractMonitorView.ChannelHandle>)var7_16);
                        continue;
                    }
                    ArrayList<AbstractMap.SimpleImmutableEntry<String, AbstractMonitorView.ChannelHandle>> branch = (ArrayList<AbstractMap.SimpleImmutableEntry<String, AbstractMonitorView.ChannelHandle>>)branches.get(pathSegments[0]);
                    if (branch == null) {
                        branch = new ArrayList<AbstractMap.SimpleImmutableEntry<String, AbstractMonitorView.ChannelHandle>>();
                        branches.put(pathSegments[0], branch);
                    }
                    StringJoiner sj = new StringJoiner("/");
                    for (int i = 1; i < pathSegments.length; ++i) {
                        sj.add(pathSegments[i]);
                    }
                    branch.add(new AbstractMap.SimpleImmutableEntry<String, AbstractMonitorView.ChannelHandle>(sj.toString(), entry.getValue()));
                }
                if (!leaves.isEmpty()) {
                    tableModel = SectionedTable.getInstance(leaves, this.desc.isCompact() ? TreeView.this.compactFields : TreeView.this.fields, null);
                    MonitorTableNode monitorTableNode = new MonitorTableNode(tableModel);
                    tableModel.setChangeListener(monitorTableNode);
                    this.add(monitorTableNode);
                }
                if (!arrayList.isEmpty()) {
                    tableModel = MeshTable.getInstance(arrayList, this.desc.isCompact() ? TreeView.this.compactFields : TreeView.this.fields);
                    MonitorTableNode monitorTableNode = new MonitorTableNode(tableModel);
                    tableModel.setChangeListener(monitorTableNode);
                    this.add(monitorTableNode);
                }
                if (!branches.isEmpty()) {
                    for (Map.Entry entry : branches.entrySet()) {
                        InterNode child = new InterNode((String)entry.getKey());
                        this.add(child);
                        ((ArrayList)entry.getValue()).trimToSize();
                        child.init((Collection)entry.getValue());
                    }
                }
            }
        }

        protected void rebuild() {
            if (this.data != null && !this.data.isEmpty()) {
                TreeView.this.updateDescriptor(this);
                Collection<Map.Entry<String, AbstractMonitorView.ChannelHandle>> data = this.data;
                this.clear();
                this.init(data);
                TreeView.this.treeModel.nodeStructureChanged(this);
                this.restoreExpansion();
            }
        }

        @Override
        void clear() {
            super.clear();
            this.data = null;
        }

        @Override
        InterNodeDescriptor save() {
            InterNodeDescriptor descriptor = new InterNodeDescriptor(this.desc);
            descriptor.setExpanded(TreeView.this.tree.isExpanded(new TreePath(this.getPath())));
            return descriptor;
        }

        void restoreExpansion() {
            Enumeration<TreeNode> en = this.depthFirstEnumeration();
            while (en.hasMoreElements()) {
                Node node = (Node)en.nextElement();
                if (!(node instanceof InterNode)) continue;
                InterNode n = (InterNode)node;
                if (!n.desc.isExpanded()) continue;
                TreeView.this.tree.expandPath(new TreePath(n.getPath()));
            }
        }

        public InterNodeDescriptor getDescriptor() {
            return this.desc;
        }

        Collection<Map.Entry<String, AbstractMonitorView.ChannelHandle>> getData() {
            return this.data;
        }
    }

    private class Node
    extends DefaultMutableTreeNode {
        Node() {
        }

        Node(String name) {
            super(name);
        }

        void clear() {
            Enumeration<TreeNode> en = this.children();
            while (en.hasMoreElements()) {
                ((Node)en.nextElement()).clear();
            }
            this.removeAllChildren();
        }

        Serializable save() {
            return null;
        }

        void restore(Serializable storageBean) {
        }

        protected String getPathString() {
            StringJoiner sj = new StringJoiner("/");
            for (TreeNode node : this.getPath()) {
                if (node == TreeView.this.root) continue;
                sj.add(node.toString());
            }
            return sj.toString();
        }
    }

    private static abstract class DisplayModeAction
    extends AbstractAction {
        private InterNodeDescriptor.DisplayMode mode;

        DisplayModeAction(InterNodeDescriptor.DisplayMode mode) {
            super(mode.toString());
            this.mode = mode;
        }
    }

    class TreeEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        private final TreeRenderer renderer;
        private Object editorValue;
        private final JPopupMenu popup;
        private final Action compactAct;
        private final Action sectionAct;
        private final EnumMap<InterNodeDescriptor.DisplayMode, DisplayModeAction> modeAct;

        public TreeEditor() {
            JCheckBoxMenuItem menuItem;
            this.renderer = new TreeRenderer(true);
            this.popup = new JPopupMenu();
            JMenu menu = new JMenu("Display mode...");
            this.modeAct = new EnumMap(InterNodeDescriptor.DisplayMode.class);
            for (final InterNodeDescriptor.DisplayMode mode : InterNodeDescriptor.DisplayMode.values()) {
                DisplayModeAction act = new DisplayModeAction(mode){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (TreeEditor.this.editorValue instanceof InterNode) {
                            InterNode node = (InterNode)TreeEditor.this.editorValue;
                            TreeEditor.this.modeAct.values().forEach(act -> act.putValue("SwingSelectedKey", act.equals(this)));
                            node.getDescriptor().setDisplayMode(mode);
                            node.rebuild();
                        }
                    }
                };
                this.modeAct.put(mode, act);
                menuItem = new JCheckBoxMenuItem(act);
                menu.add(menuItem);
            }
            this.popup.add(menu);
            this.compactAct = new AbstractAction("Compact"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TreeEditor.this.editorValue instanceof InterNode) {
                        InterNode node = (InterNode)TreeEditor.this.editorValue;
                        Boolean v = (Boolean)this.getValue("SwingSelectedKey");
                        node.getDescriptor().setCompact(Boolean.TRUE.equals(v));
                        node.rebuild();
                    }
                }
            };
            menuItem = new JCheckBoxMenuItem(this.compactAct);
            this.popup.add(menuItem);
            this.sectionAct = new AbstractAction("Sectioned"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TreeEditor.this.editorValue instanceof InterNode) {
                        InterNode node = (InterNode)TreeEditor.this.editorValue;
                        Boolean v = (Boolean)this.getValue("SwingSelectedKey");
                        node.getDescriptor().setSection(Boolean.TRUE.equals(v));
                        node.rebuild();
                    }
                }
            };
            menuItem = new JCheckBoxMenuItem(this.sectionAct);
            this.popup.add(menuItem);
            this.renderer.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.maybeShowPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.maybeShowPopup(e);
                }

                private void maybeShowPopup(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        TreeEditor.this.popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            this.editorValue = value;
            if (this.editorValue instanceof InterNode) {
                InterNode node = (InterNode)this.editorValue;
                this.compactAct.putValue("SwingSelectedKey", node.getDescriptor().isCompact());
                this.sectionAct.putValue("SwingSelectedKey", node.getDescriptor().isSection());
                for (Map.Entry<InterNodeDescriptor.DisplayMode, DisplayModeAction> e : this.modeAct.entrySet()) {
                    e.getValue().putValue("SwingSelectedKey", e.getKey().equals((Object)node.getDescriptor().getDisplayMode()));
                }
            }
            return this.renderer.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, true);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return false;
        }

        @Override
        public Object getCellEditorValue() {
            return this.editorValue;
        }
    }

    class TreeRenderer
    extends DefaultTreeCellRenderer {
        private final boolean editable;

        TreeRenderer(boolean editable) {
            this.editable = editable;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof InterNode) {
                Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                return c;
            }
            if (value instanceof DisplayNode) {
                DisplayNode node = (DisplayNode)value;
                return this.editable ? node.getEditorComponent() : node.getRendererComponent();
            }
            return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        }
    }

    class Tree
    extends JTree
    implements MonitorDisplay {
        Tree(TreeModel model) {
            super(model);
            this.setRootVisible(true);
            this.setShowsRootHandles(true);
            this.setRowHeight(0);
            this.setCellRenderer(new TreeRenderer(false));
            this.setCellEditor(new TreeEditor());
            this.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (TreeView.this.tree.getRowForLocation(e.getX(), e.getY()) != -1) {
                        TreeView.this.tree.startEditingAtPath(TreeView.this.tree.getPathForLocation(e.getX(), e.getY()));
                    }
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                }
            });
            this.setEditable(true);
            this.getSelectionModel().setSelectionMode(1);
        }

        @Override
        public void saveData(OutputStream out, String mimeType) {
            List<AgentChannel> channels = TreeView.this.path2data.values().stream().map(handle -> handle.getChannel()).filter(channel -> channel != null).collect(Collectors.toList());
            LsstMonitorPlugin.saveData(out, mimeType, channels, TreeView.this.fields);
        }
    }
}

