/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.lsst.ccs.gconsole.agent.AgentChannel;
import org.lsst.ccs.gconsole.agent.AgentChannelState;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.plugins.trending.TrendingService;

public abstract class MonitorTable
extends AbstractTableModel
implements AbstractMonitorView.ChannelDisplay {
    public static final List<MonitorField> defaultFields = Collections.unmodifiableList(Arrays.asList(MonitorField.VALUE, MonitorField.UNITS, MonitorField.LOW, MonitorField.ALERT_LOW, MonitorField.HIGH, MonitorField.ALERT_HIGH, MonitorField.DESCR));
    public static final List<MonitorField> defaultCompactFields = Collections.unmodifiableList(Arrays.asList(MonitorField.VALUE));
    public static final Color COLOR_FG = Color.BLACK;
    public static final Color COLOR_BG = Color.WHITE;
    private static final Color COLOR_GOOD = new Color(160, 255, 160);
    private static final Color COLOR_WARN = new Color(255, 255, 100);
    private static final Color COLOR_ERR = new Color(255, 160, 160);
    private static final Color COLOR_OFF = new Color(160, 200, 255);
    private static final Color COLOR_POPUP = new Color(255, 255, 160);
    private static final Color COLOR_MULTI = Color.LIGHT_GRAY;
    private static final Color COLOR_NA = COLOR_BG;
    private static final String TEXT_MULTI = "---";
    private static final int HA_MULTI = 0;
    protected int nRows;
    protected int nColumns;
    protected ArrayList<ArrayList<Cell>> cells;
    protected ChangeListener listener;
    private static final List<MonitorField> AFFECTED_BY_STATE = Arrays.asList(MonitorField.VALUE, MonitorField.HIGH, MonitorField.LOW);
    protected final ChangeEvent CHANGE_EVENT = new ChangeEvent(this);

    MonitorTable() {
    }

    MonitorTable(Cell[][] cells) {
        this.nRows = cells.length;
        this.nColumns = cells[0].length;
        this.cells = new ArrayList(this.nRows);
        for (Cell[] row : cells) {
            this.cells.add(new ArrayList<Cell>(Arrays.asList(row)));
        }
    }

    public void destroy() {
    }

    @Override
    public int getRowCount() {
        return this.nRows;
    }

    @Override
    public int getColumnCount() {
        return this.nColumns;
    }

    @Override
    public Data getValueAt(int row, int column) {
        return this.cells.get(row).get(column).getData();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        Cell cell = this.cells.get(row).get(column);
        if (cell.getItems().size() != 1) {
            return false;
        }
        MonitorField field = cell.getField();
        return field != null && field.isEditable();
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        Cell cell = this.cells.get(row).get(column);
        MonitorField field = cell.getField();
        boolean isHigh = MonitorField.HIGH.equals(field);
        if ((isHigh || MonitorField.LOW.equals(field)) && cell.getItems().size() == 1) {
            try {
                double newValue = Double.parseDouble(aValue.toString());
                AgentChannel channel = cell.getItems().get(0).getChannel();
                if (channel != null) {
                    String target = isHigh ? "limitHi" : "limitLo";
                    Console.getConsole().sendCommand(channel.getAgentName() + "/change", channel.getLocalPath(), target, newValue);
                }
            }
            catch (NumberFormatException x) {
                return;
            }
            super.setValueAt(this.getValueAt(row, column), row, column);
        } else {
            super.setValueAt(aValue, row, column);
        }
    }

    @Override
    public void update(AbstractMonitorView.ChannelHandle item, List<String> attributes) {
        HashSet<MonitorField> fields = MonitorTable.translateAttributesToFields(attributes);
        fields.forEach(field -> {
            List<int[]> affectedCells = this.getCells(item, (MonitorField)field);
            for (int[] index : affectedCells) {
                Data data;
                Cell cell = this.cells.get(index[0]).get(index[1]);
                field = cell.getField();
                List<AbstractMonitorView.ChannelHandle> items = cell.getItems();
                int nItems = items.size();
                if (cell.getData() == Data.MULTI) {
                    data = this.format(items.get(0), (MonitorField)field);
                    for (int i = 1; i < nItems; ++i) {
                        Data other = this.format(items.get(i), (MonitorField)field);
                        if (data.equals(other)) continue;
                        data = null;
                        break;
                    }
                    if (data == null) continue;
                    cell.setData(data);
                    this.fireTableCellUpdated(index[0], index[1]);
                    continue;
                }
                data = this.format(item, (MonitorField)field);
                if (data.equals(cell.getData())) continue;
                cell.setData(data);
                this.fireTableCellUpdated(index[0], index[1]);
            }
        });
        this.fireChangeEvent();
    }

    protected List<int[]> getCells(AbstractMonitorView.ChannelHandle item, MonitorField field) {
        ArrayList<int[]> out = new ArrayList<int[]>();
        for (int row = 0; row < this.nRows; ++row) {
            for (int col = 0; col < this.nColumns; ++col) {
                Cell cell = this.cells.get(row).get(col);
                if (!cell.getItems().contains(item) || field != null && !field.equals(cell.getField())) continue;
                out.add(new int[]{row, col});
            }
        }
        return out;
    }

    protected Data format(AbstractMonitorView.ChannelHandle item, MonitorField field) {
        if (MonitorField.NAME.equals(field)) {
            return new Data(item.getPath(), null, null, 2);
        }
        AgentChannel channel = item.getChannel();
        if (channel == null) {
            return Data.NA;
        }
        Object value = channel.get(field.name());
        if (value == null) {
            return Data.NA;
        }
        String text = null;
        Color fgColor = null;
        Color bgColor = null;
        Integer horizontalAlignment = null;
        if (MonitorField.VALUE.equals(field)) {
            if (value instanceof Double) {
                if (((Double)value).isNaN()) {
                    text = "NaN";
                } else {
                    double d = (Double)value;
                    String f = (String)channel.get("MONITOR_FORMAT");
                    text = String.format(f == null ? "%f " : f, d);
                }
            } else {
                text = value.toString();
            }
            Object o = channel.get("MONITOR_STATE");
            if (o instanceof AgentChannelState) {
                AgentChannelState state = (AgentChannelState)o;
                bgColor = state.isOnline() ? (state.isGood() ? COLOR_GOOD : COLOR_ERR) : COLOR_OFF;
            }
            horizontalAlignment = 4;
        } else if (MonitorField.HIGH.equals(field) || MonitorField.LOW.equals(field)) {
            Object o;
            double d = Double.NaN;
            if (value instanceof Double) {
                d = (Double)value;
            } else if (value instanceof Float) {
                d = ((Float)value).doubleValue();
            } else if (value instanceof String) {
                try {
                    d = Double.parseDouble((String)value);
                }
                catch (NumberFormatException x) {
                    text = (String)value;
                }
            }
            if (Double.isNaN(d)) {
                if (text == null) {
                    text = "NaN";
                }
            } else {
                String f = (String)channel.get("MONITOR_FORMAT");
                text = String.format(f == null ? "%f " : f, d);
            }
            if ((o = channel.get("MONITOR_STATE")) instanceof AgentChannelState) {
                AgentChannelState state = (AgentChannelState)o;
                if (MonitorField.HIGH.equals(field) ? state.isHighLimitChange() : state.isLowLimitChange()) {
                    fgColor = Color.BLUE;
                }
            }
        } else if (MonitorField.LOW_WARN.equals(field) || MonitorField.HIGH_WARN.equals(field)) {
            if (value instanceof Double) {
                if (((Double)value).isNaN()) {
                    text = "NaN";
                } else {
                    double d = (Double)value;
                    String f = (String)channel.get("MONITOR_FORMAT");
                    text = f == null ? String.valueOf(d) : String.format(f, d);
                }
            } else {
                text = value.toString();
            }
        } else {
            text = MonitorField.ALERT_HIGH.equals(field) || MonitorField.ALERT_LOW.equals(field) ? "  \u2713" : value.toString();
        }
        return new Data(text, fgColor, bgColor, horizontalAlignment);
    }

    protected boolean format(Cell cell) {
        Data newData;
        MonitorField field = cell.getField();
        List<AbstractMonitorView.ChannelHandle> handles = cell.getItems();
        switch (handles.size()) {
            case 0: {
                newData = new Data(field.getTitle(), 0);
                break;
            }
            case 1: {
                newData = this.format(handles.get(0), field);
                break;
            }
            default: {
                ArrayList<Data> all = new ArrayList<Data>(handles.size());
                for (AbstractMonitorView.ChannelHandle h : handles) {
                    all.add(this.format(h, field));
                }
                newData = Data.merge(all);
            }
        }
        if (newData.equals(cell.getData())) {
            return false;
        }
        cell.setData(newData);
        return true;
    }

    protected boolean format(Cell cell, AbstractMonitorView.ChannelHandle item) {
        return this.format(cell);
    }

    public void setChangeListener(ChangeListener listener) {
        this.listener = listener;
    }

    protected void fireChangeEvent() {
        if (this.listener != null) {
            this.listener.stateChanged(this.CHANGE_EVENT);
        }
    }

    public JTable getTable() {
        JTable table = this.makeTable();
        JTableHeader header = table.getTableHeader();
        header.setReorderingAllowed(false);
        header.setResizingAllowed(false);
        TableCellRenderer headerRenderer = header.getDefaultRenderer();
        if (headerRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)headerRenderer).setHorizontalAlignment(0);
        }
        Renderer renderer = new Renderer();
        table.setDefaultRenderer(Object.class, renderer);
        table.setAutoResizeMode(3);
        table.setRowSelectionAllowed(false);
        table.setColumnSelectionAllowed(false);
        table.setRowHeight(table.getRowHeight() + 2);
        table.setShowGrid(true);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MonitorTable.this.tableMouseClicked(evt);
            }
        });
        for (int col = 0; col < this.nColumns; ++col) {
            TableColumn column = table.getColumnModel().getColumn(col);
            Component comp = headerRenderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
            int maxWidth = comp.getPreferredSize().width;
            for (int row = 0; row < this.nRows; ++row) {
                comp = renderer.getTableCellRendererComponent(table, this.getValueAt(row, col), false, false, row, col);
                maxWidth = Math.max(maxWidth, comp.getPreferredSize().width);
            }
            column.setPreferredWidth(maxWidth);
        }
        return table;
    }

    protected JTable makeTable() {
        return new JTable(this);
    }

    protected void tableMouseClicked(MouseEvent evt) {
        List<AbstractMonitorView.ChannelHandle> items;
        Cell cc;
        int nClick = evt.getClickCount();
        JTable table = (JTable)evt.getSource();
        Point point = evt.getPoint();
        int row = table.rowAtPoint(point);
        int column = table.columnAtPoint(point);
        if (nClick != 1 && nClick == 2 && (cc = this.cells.get(row).get(column)).getField().equals(MonitorField.VALUE) && (items = cc.getItems()).size() == 1) {
            AbstractMonitorView.ChannelHandle item = items.get(0);
            String[] path = new String[]{item.getChannel().getAgentName(), item.getChannel().getLocalPath()};
            TrendingService trending = (TrendingService)Console.getConsole().getConsoleLookup().lookup(TrendingService.class);
            if (trending == null) {
                return;
            }
            trending.show(path);
        }
    }

    public boolean showHeader() {
        return true;
    }

    public static List<MonitorField> translateAttributesToFields(String attribute) {
        if ("MONITOR_STATE".equals(attribute)) {
            return AFFECTED_BY_STATE;
        }
        return Collections.singletonList(MonitorField.valueOf(attribute));
    }

    public static HashSet<MonitorField> translateAttributesToFields(Collection<String> attributes) {
        HashSet<MonitorField> fields = new HashSet<MonitorField>();
        if (attributes == null) {
            fields.add(null);
        } else {
            attributes.forEach(att -> {
                List<MonitorField> f = MonitorTable.translateAttributesToFields(att);
                fields.addAll(f);
            });
        }
        return fields;
    }

    public static List<MonitorField> trimAbsentFields(List<MonitorField> fields, Collection<AbstractMonitorView.ChannelHandle> channels, Collection<MonitorField> exclude) {
        LinkedHashSet<MonitorField> requestedFields = new LinkedHashSet<MonitorField>(fields);
        if (exclude != null) {
            requestedFields.removeAll(exclude);
        }
        HashSet<MonitorField> presentFields = new HashSet<MonitorField>();
        for (AbstractMonitorView.ChannelHandle ch : channels) {
            AgentChannel channel = ch.getChannel();
            if (channel == null) continue;
            Iterator it = requestedFields.iterator();
            while (it.hasNext()) {
                MonitorField f = (MonitorField)it.next();
                if (channel.get(f.name()) == null) continue;
                presentFields.add(f);
                it.remove();
            }
            if (!requestedFields.isEmpty()) continue;
            break;
        }
        if (fields.size() == presentFields.size()) {
            return fields;
        }
        ArrayList<MonitorField> out = new ArrayList<MonitorField>(presentFields.size());
        for (MonitorField f : fields) {
            if (!presentFields.contains(f)) continue;
            out.add(f);
        }
        return out;
    }

    public static List<MonitorField> trimAbsentFields(List<MonitorField> fields, Collection<AbstractMonitorView.ChannelHandle> channels) {
        HashSet<MonitorField> presentFields = new HashSet<MonitorField>();
        for (AbstractMonitorView.ChannelHandle ch : channels) {
            AgentChannel channel = ch.getChannel();
            if (channel != null) {
                for (MonitorField f : fields) {
                    if (channel.get(f.name()) == null) continue;
                    presentFields.add(f);
                }
            }
            if (presentFields.size() != fields.size()) continue;
            return fields;
        }
        if (presentFields.size() > 0) {
            ArrayList<MonitorField> out = new ArrayList<MonitorField>(fields);
            out.retainAll(presentFields);
            out.trimToSize();
            return out;
        }
        return fields;
    }

    public static List<MonitorField> moveNameToFront(List<MonitorField> fields) {
        if (fields.isEmpty()) {
            return Collections.singletonList(MonitorField.NAME);
        }
        if (MonitorField.NAME.equals(fields.get(0))) {
            return fields;
        }
        ArrayList<MonitorField> out = new ArrayList<MonitorField>(fields.size() + 1);
        out.add(MonitorField.NAME);
        for (MonitorField f : fields) {
            if (MonitorField.NAME.equals(f)) continue;
            out.add(f);
        }
        out.trimToSize();
        return out;
    }

    public Serializable save() {
        return null;
    }

    public void restore(Serializable storageBean) {
    }

    static /* synthetic */ Color access$100() {
        return COLOR_NA;
    }

    static class Renderer
    extends DefaultTableCellRenderer {
        Renderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Data d = (Data)value;
            super.getTableCellRendererComponent(table, d.text, false, false, row, column);
            this.setBackground(d.bgColor);
            this.setForeground(d.fgColor);
            this.setHorizontalAlignment(d.horizontalAlignment);
            this.setToolTipText(d.toolTip);
            return this;
        }
    }

    protected static class Data {
        static final Data MULTI = new Data("-", COLOR_FG, MonitorTable.access$000(), 0);
        static final Data NA = new Data("", COLOR_FG, MonitorTable.access$100(), 0);
        static final Data EMPTY = new Data("", COLOR_FG, COLOR_BG, 0);
        final String text;
        final Color fgColor;
        final Color bgColor;
        final int horizontalAlignment;
        final String toolTip;

        Data(String text, Color fgColor, Color bgColor, Integer horizontalAlignment, String toolTip) {
            this.text = text == null ? "" : text;
            this.fgColor = fgColor == null ? COLOR_FG : fgColor;
            this.bgColor = bgColor == null ? COLOR_BG : bgColor;
            this.horizontalAlignment = horizontalAlignment == null ? 0 : horizontalAlignment;
            this.toolTip = toolTip;
        }

        Data(String text, Color fgColor, Color bgColor, Integer horizontalAlignment) {
            this(text, fgColor, bgColor, horizontalAlignment, null);
        }

        Data() {
            this(null, null, null, null);
        }

        Data(String text, int horizontalAlignment) {
            this(text, null, null, horizontalAlignment, null);
        }

        Data(String text, int horizontalAlignment, String toolTip) {
            this(text, null, null, horizontalAlignment, toolTip);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Data)) {
                return false;
            }
            Data other = (Data)obj;
            return Objects.equals(this.text, other.text) && Objects.equals(this.fgColor, other.fgColor) && Objects.equals(this.bgColor, other.bgColor) && Objects.equals(this.horizontalAlignment, other.horizontalAlignment);
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = result * 31 + (this.text == null ? 0 : this.text.hashCode());
            result = result * 31 + (this.fgColor == null ? 0 : this.fgColor.hashCode());
            result = result * 31 + (this.bgColor == null ? 0 : this.bgColor.hashCode());
            result = result * 31 + this.horizontalAlignment;
            return result;
        }

        public String toString() {
            return this.text;
        }

        public static Data merge(List<Data> dataset) {
            switch (dataset.size()) {
                case 0: {
                    return EMPTY;
                }
                case 1: {
                    return dataset.get(0);
                }
            }
            Iterator<Data> it = dataset.iterator();
            Data first = it.next();
            String text = first.text;
            Color fgColor = first.fgColor;
            Color bgColor = first.bgColor;
            int horizontalAlignment = first.horizontalAlignment;
            while (it.hasNext()) {
                Data other = it.next();
                if (!text.equals(other.text)) {
                    text = MonitorTable.TEXT_MULTI;
                }
                fgColor = Data.merge(fgColor, other.fgColor, COLOR_FG);
                bgColor = Data.merge(bgColor, other.bgColor, COLOR_BG);
                if (horizontalAlignment == other.horizontalAlignment) continue;
                horizontalAlignment = 0;
            }
            return new Data(text, fgColor, bgColor, horizontalAlignment);
        }

        private static Color merge(Color c1, Color c2, Color defaultColor) {
            if (c1.equals(c2) || c2.equals(defaultColor)) {
                return c1;
            }
            if (c1.equals(defaultColor)) {
                return c2;
            }
            return COLOR_MULTI;
        }
    }

    protected static class Cell {
        protected static Cell EMPTY = new Cell(Collections.emptyList(), MonitorField.NULL, Data.EMPTY);
        private final List<AbstractMonitorView.ChannelHandle> items;
        private final MonitorField field;
        private Data data;

        Cell() {
            this(Collections.emptyList(), MonitorField.NULL);
        }

        Cell(AbstractMonitorView.ChannelHandle item, MonitorField field) {
            this(item == null ? Collections.emptyList() : Collections.singletonList(item), field);
        }

        Cell(List<? extends AbstractMonitorView.ChannelHandle> items, MonitorField field) {
            this(items, field, null);
        }

        Cell(List<? extends AbstractMonitorView.ChannelHandle> items, MonitorField field, Data data) {
            this.items = items == null ? Collections.emptyList() : items;
            this.field = field == null ? MonitorField.NULL : field;
            this.data = data;
        }

        public List<AbstractMonitorView.ChannelHandle> getItems() {
            return this.items;
        }

        public MonitorField getField() {
            return this.field;
        }

        public void setData(Data data) {
            this.data = data;
        }

        public Data getData() {
            return this.data;
        }
    }
}

