/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.util.HashMap;

public class MonitorField {
    private static final HashMap<String, MonitorField> fields = new HashMap();
    public static final MonitorField NULL = MonitorField.getInstance("_NULL_", "", false, false);
    public static final MonitorField NAME = MonitorField.getInstance("name", "Name", false, false);
    public static final MonitorField VALUE = MonitorField.getInstance("value", "Value", true, false);
    public static final MonitorField UNITS = MonitorField.getInstance("unit", "Units", false, false);
    public static final MonitorField LOW = MonitorField.getInstance("alarmLow", "Low Limit", true, true);
    public static final MonitorField ALERT_LOW = MonitorField.getInstance("alertLow", "Al.", false, false);
    public static final MonitorField HIGH = MonitorField.getInstance("alarmHigh", "High Limit", true, true);
    public static final MonitorField ALERT_HIGH = MonitorField.getInstance("alertHigh", "Al.", false, false);
    public static final MonitorField DESCR = MonitorField.getInstance("description", "Description", false, false);
    public static final MonitorField LOW_WARN = MonitorField.getInstance("warningLow", "Low Warn", true, true);
    public static final MonitorField HIGH_WARN = MonitorField.getInstance("warningHigh", "High Warn", true, true);
    public static final String ID_KEY = "MONITOR_ID";
    public static final String PAGE_KEY = "MONITOR_PAGE";
    public static final String STATE_KEY = "MONITOR_STATE";
    public static final String FORMAT_KEY = "MONITOR_FORMAT";
    private final String id;
    private final boolean updatable;
    private final boolean editable;
    private final String title;

    public MonitorField(String name, String title, boolean updatable, boolean editable) {
        this.id = name;
        this.updatable = updatable;
        this.editable = editable;
        this.title = title;
    }

    public static synchronized MonitorField getInstance(String name, String title, boolean updatable, boolean editable) {
        if (fields.containsKey(name)) {
            throw new IllegalArgumentException("Field with ID " + name + " already exists.");
        }
        MonitorField field = new MonitorField(name, title, updatable, editable);
        fields.put(name, field);
        return field;
    }

    public static synchronized MonitorField getInstance(String name) {
        MonitorField field = MonitorField.valueOf(name);
        if (field == null) {
            field = MonitorField.getInstance(name, name, true, false);
        }
        return field;
    }

    public static synchronized MonitorField valueOf(String name) {
        return fields.get(name);
    }

    public String name() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public String toString() {
        return this.title;
    }

    public boolean equals(Object obj) {
        return obj instanceof MonitorField && this.id.equals(((MonitorField)obj).id) || this.id.equals(obj);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

