/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.jas3;

import java.util.Map;
import org.freehep.application.Application;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.PluginFactory;
import org.freehep.application.studio.PluginInfo;
import org.freehep.application.studio.Studio;
import org.lsst.ccs.gconsole.base.ComponentDescriptor;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.jas3.Jas3Console;
import org.lsst.ccs.gconsole.jas3.Jas3PluginServices;

public class LsstPluginFactory
implements PluginFactory {
    private static final Jas3Console agent = (Jas3Console)Console.getConsole();
    private static final Map<String, ComponentDescriptor> config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Plugin getInstance(Studio studio, PluginInfo pluginDescriptor, ClassLoader loader) throws Throwable {
        Jas3PluginServices provider;
        Class<?> pluginClass = loader.loadClass(pluginDescriptor.getMainClass());
        if (Plugin.class.isAssignableFrom(pluginClass)) {
            return (Plugin)pluginClass.newInstance();
        }
        ConsolePlugin consolePlugin = (ConsolePlugin)pluginClass.newInstance();
        JasPlugin jasPlugin = new JasPlugin(consolePlugin);
        Jas3PluginServices jas3PluginServices = provider = new Jas3PluginServices(agent, consolePlugin, this.createDescriptor(pluginDescriptor), jasPlugin);
        synchronized (jas3PluginServices) {
            provider.start();
            consolePlugin.setServicesProvider(provider);
        }
        return jasPlugin;
    }

    private ComponentDescriptor createDescriptor(PluginInfo pluginDescriptor) {
        ComponentDescriptor descriptor = new ComponentDescriptor();
        String name = pluginDescriptor.getName();
        descriptor.setName(name);
        descriptor.setVersion(pluginDescriptor.getVersion());
        descriptor.setDescription(pluginDescriptor.getDescription());
        ComponentDescriptor configuration = config.remove(name);
        descriptor.setConfiguration(configuration);
        return descriptor;
    }

    static {
        agent.startAgent();
        config = agent.readDescriptors(null);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                agent.shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
        ((Studio)Application.getApplication()).getLookup().add((Object)agent);
    }

    private static class JasPlugin
    extends Plugin {
        private final ConsolePlugin plugin;

        JasPlugin(ConsolePlugin consolePlugin) {
            this.plugin = consolePlugin;
        }

        protected synchronized void init() throws Throwable {
        }

        protected synchronized void postInit() {
            this.plugin.initialize();
            agent.getConsoleLookup().add((Object)this.plugin);
        }

        protected synchronized void applicationVisible() {
            this.plugin.start();
        }

        protected synchronized void shutdown() {
            this.plugin.stop();
            this.plugin.shutdown();
        }
    }
}

