/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.base;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.agent.AgentStatusEvent;
import org.lsst.ccs.gconsole.agent.AgentStatusListener;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.gconsole.base.panel.Panel;

class OptionalPageHandler
implements AgentStatusListener {
    private final OptionalPage descriptor;
    private final Console console;
    private final TreeMap<String, Page> name2page = new TreeMap();

    OptionalPageHandler(OptionalPage descriptor, Console console) {
        this.descriptor = descriptor;
        this.console = console;
    }

    void start() {
        this.console.getStatusAggregator().addListener(this, null, Collections.emptyList());
    }

    void stop() {
        this.console.getStatusAggregator().removeListener(this);
        SwingUtilities.invokeLater(() -> new ArrayList<Page>(this.name2page.values()).forEach(page -> page.uninstall()));
    }

    OptionalPage getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void connect(AgentStatusEvent event) {
        SwingUtilities.invokeLater(() -> this.onConnect(event.getSource()));
    }

    @Override
    public void disconnect(AgentStatusEvent event) {
        SwingUtilities.invokeLater(() -> this.onDisconnect(event.getSource()));
    }

    private void onConnect(AgentInfo agent) {
        Page page;
        String name = this.descriptor.getPage(agent);
        if (name == null) {
            return;
        }
        if (name.trim().isEmpty()) {
            name = agent.getName();
        }
        if ((page = this.name2page.get(name)) == null) {
            page = new Page(name);
            page.install();
        }
        page.agents.add(agent);
        if (page.isActive()) {
            page.open(this.descriptor.open(agent, page.component));
        }
    }

    private void onDisconnect(AgentInfo agent) {
        for (Page page : this.name2page.values()) {
            Iterator<AgentInfo> it = page.agents.iterator();
            while (it.hasNext()) {
                AgentInfo a = it.next();
                if (!a.getName().equals(agent.getName())) continue;
                it.remove();
                boolean close = this.descriptor.agentDisconnected(a);
                if (page.agents.isEmpty()) {
                    page.uninstall();
                } else if (close) {
                    this.console.getPanelManager().close(page.component);
                }
                return;
            }
        }
    }

    private class Page
    extends AbstractAction {
        final String name;
        JComponent component;
        final ArrayList<AgentInfo> agents;

        Page(String name) {
            super(name);
            this.agents = new ArrayList(1);
            this.name = name;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isActive()) {
                this.component = null;
                for (AgentInfo agent : this.agents) {
                    this.open(OptionalPageHandler.this.descriptor.open(agent, this.component));
                }
            } else if (this.component != null) {
                OptionalPageHandler.this.console.getPanelManager().close(this.component);
            }
        }

        boolean isActive() {
            return (Boolean)this.getValue("SwingSelectedKey");
        }

        void install() {
            this.putValue("SwingSelectedKey", OptionalPageHandler.this.descriptor.isAutoOpen());
            OptionalPageHandler.this.name2page.put(this.name, this);
            OptionalPageHandler.this.console.addMenu(this, null, ("Window:1:1/CCS/" + OptionalPageHandler.this.descriptor.getPath()).split("/"));
        }

        void open(JComponent component) {
            if (this.component != null || component == null) {
                return;
            }
            this.component = component;
            TreeMap<Panel, Object> par = new TreeMap<Panel, Object>();
            par.put(Panel.TITLE, this.name);
            Consumer<JComponent> onClose = c -> this.close();
            par.put(Panel.ON_CLOSE, onClose);
            OptionalPageHandler.this.console.getPanelManager().open((Component)component, par);
        }

        void close() {
            this.putValue("SwingSelectedKey", false);
            OptionalPageHandler.this.descriptor.close(this.name);
        }

        void uninstall() {
            OptionalPageHandler.this.console.removeMenu(("Window/CCS/" + OptionalPageHandler.this.descriptor.getPath() + "/" + this.name).split("/"));
            if (this.component != null) {
                OptionalPageHandler.this.console.getPanelManager().close(this.component);
            }
            OptionalPageHandler.this.name2page.remove(this.name);
        }
    }
}

