/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb.dao;

import java.util.List;
import java.util.logging.Level;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.lsst.ccs.localdb.configdb.model.HqlDAO;
import org.lsst.ccs.localdb.configdb.model.PackCst;

public class HibernateDAO
extends HqlDAO {
    protected SessionFactory sessionFactory;
    Session session;
    Transaction currentTransaction;
    private boolean exceptionFired;

    public HibernateDAO() {
        this(null);
    }

    public HibernateDAO(SessionFactory fac) {
        this.sessionFactory = fac;
        this.session = this.openSession();
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public void begin() {
        PackCst.CURLOG.fine((Object)"begin transaction");
        this.session = this.getCurrentSession();
        this.exceptionFired = false;
        this.currentTransaction = this.session.beginTransaction();
    }

    @Override
    public void end() {
        PackCst.CURLOG.fine((Object)"end transaction");
        if (!this.exceptionFired) {
            this.session.flush();
            this.currentTransaction.commit();
            this.currentTransaction = null;
        }
    }

    @Override
    public void fail() {
        if (this.currentTransaction != null) {
            this.currentTransaction.rollback();
        }
    }

    @Override
    public void fail(Throwable th) {
        PackCst.CURLOG.log(Level.SEVERE, "", th);
        this.fail();
    }

    @Override
    public void close() {
        this.session.close();
        this.sessionFactory.close();
    }

    protected Session getCurrentSession() {
        Session res = this.sessionFactory.getCurrentSession();
        this.setSession(new SessionDelegate(res));
        return res;
    }

    protected final Session openSession() {
        Session res = this.sessionFactory.openSession();
        this.setSession(new SessionDelegate(res));
        return res;
    }

    public List dumpTable(String table) {
        this.begin();
        List res = this.session.createSQLQuery("Select * from " + table).list();
        this.close();
        return res;
    }

    class SessionDelegate
    implements HqlDAO.AbstractSession {
        Session session;

        SessionDelegate(Session session) {
            this.session = session;
        }

        @Override
        public void save(Object o) throws HibernateException {
            this.session.save(o);
        }

        @Override
        public void saveOrUpdate(Object o) throws HibernateException {
            this.session.saveOrUpdate(o);
        }

        @Override
        public void delete(Object o) throws HibernateException {
            this.session.delete(o);
        }

        @Override
        public void flush() {
            this.session.flush();
        }

        @Override
        public HqlDAO.AbstractQuery createQuery(final String s) {
            return new HqlDAO.AbstractQuery(){
                Query query;
                {
                    this.query = SessionDelegate.this.session.createQuery(s);
                }

                @Override
                public List list() {
                    return this.query.list();
                }
            };
        }
    }
}

