/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.gconsole.plugins.trending.Trend;
import org.lsst.ccs.gconsole.plugins.trending.TrendData;
import org.lsst.ccs.gconsole.plugins.trending.TrendingChannel;
import org.lsst.ccs.gconsole.plugins.trending.TrendingFilter;
import org.lsst.ccs.gconsole.plugins.trending.TrendingSource;

public class RenamingFilter
implements TrendingFilter {
    private final Map<TrendingChannel, String> nameMap = new HashMap<TrendingChannel, String>();

    public RenamingFilter(Map<TrendingChannel, String> nameMap) {
        this.nameMap.putAll(nameMap);
    }

    public RenamingFilter(Collection<String[]> entries) {
        entries.forEach(e -> {
            int n = ((String[])e).length;
            switch (n) {
                case 1: {
                    this.nameMap.put(new TrendingChannel(e[0]), e[0]);
                    break;
                }
                case 2: {
                    this.nameMap.put(new TrendingChannel(e[1]), e[0]);
                    break;
                }
                case 3: {
                    this.nameMap.put(new TrendingChannel(e[1], e[2]), e[0]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Mapping should be in {original_path, path [,title]} format.");
                }
            }
        });
    }

    @Override
    public TrendingSource filter(TrendingSource source) {
        return new Source(source);
    }

    private class Source
    extends TrendingSource
    implements TrendingSource.Listener {
        private final TrendingSource originalSource;
        private final Map<TrendingChannel, TrendingChannel> filtered2original = new HashMap<TrendingChannel, TrendingChannel>();

        private Source(TrendingSource source) {
            this.originalSource = source;
            this.populate();
        }

        @Override
        public synchronized List<TrendingChannel> getChannels() {
            return new ArrayList<TrendingChannel>(this.filtered2original.keySet());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TrendData get(TrendingChannel channel, long begin, long end, EnumSet<Trend.Meta> metadata, TrendData history) {
            TrendingChannel original;
            Source source = this;
            synchronized (source) {
                original = this.filtered2original.get(channel);
            }
            return original == null ? null : this.originalSource.get(original, begin, end, metadata, history);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void processEvent(TrendingSource.Event event) {
            HashSet<TrendingChannel> added;
            HashSet<TrendingChannel> removed;
            if (event.getSource() != this.originalSource) {
                return;
            }
            Source source = this;
            synchronized (source) {
                HashSet<TrendingChannel> before = new HashSet<TrendingChannel>(this.filtered2original.keySet());
                this.filtered2original.clear();
                this.populate();
                removed = new HashSet<TrendingChannel>(before);
                removed.removeAll(this.filtered2original.keySet());
                added = new HashSet<TrendingChannel>(this.filtered2original.keySet());
                added.removeAll(before);
            }
            this.fireEvent(new ArrayList<TrendingChannel>(removed), new ArrayList<TrendingChannel>(added));
        }

        private synchronized void populate() {
            HashMap inputMap = new HashMap();
            this.originalSource.getChannels().forEach(channel -> inputMap.put(channel.getPath(), channel));
            RenamingFilter.this.nameMap.forEach((filtered, originalPath) -> {
                TrendingChannel original = (TrendingChannel)inputMap.get(originalPath);
                if (original != null) {
                    this.filtered2original.put((TrendingChannel)filtered, original);
                }
            });
        }
    }
}

