/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.agent.AgentChannel;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.gconsole.agent.AgentStatusAggregator;
import org.lsst.ccs.gconsole.agent.AgentStatusEvent;
import org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorView;

public class CompoundView
extends AbstractMonitorView {
    private final JComponent panel;
    private final ArrayList<MonitorView> children1 = new ArrayList(0);
    private final ArrayList<MonitorView> children2 = new ArrayList(0);
    private final ArrayList<AbstractMonitorView> children3 = new ArrayList(0);

    public CompoundView(JComponent panel) {
        this.panel = panel;
    }

    @Override
    public JComponent getPanel() {
        return this.panel;
    }

    @Override
    public void setFilter(AgentChannelsFilter filter) {
        super.setFilter(filter);
        this.children1.forEach(child -> child.setFilter(filter));
        this.children2.forEach(child -> child.setFilter(filter));
    }

    public void addView(MonitorView view, boolean chainFilters) {
        if (chainFilters) {
            this.children2.add(view);
        } else {
            this.children1.add(view);
        }
    }

    public void addView(AbstractMonitorView view) {
        this.children3.add(view);
    }

    @Override
    public void connect(AgentStatusEvent event) {
        super.connect(event);
        this.children2.forEach(view -> view.connect(event.filter(view.getFilter())));
    }

    @Override
    public void configure(AgentStatusEvent event) {
        super.configure(event);
        this.children2.forEach(view -> view.configure(event.filter(view.getFilter())));
    }

    @Override
    public void statusChanged(AgentStatusEvent event) {
        super.statusChanged(event);
        this.children2.forEach(view -> view.statusChanged(event.filter(view.getFilter())));
    }

    @Override
    public void disconnect(AgentStatusEvent event) {
        super.disconnect(event);
        this.children2.forEach(view -> view.disconnect(event.filter(view.getFilter())));
    }

    @Override
    protected void connect(AgentInfo agent) {
        this.children3.forEach(view -> view.connect(agent));
    }

    @Override
    protected void disconnect(AgentInfo agent) {
        this.children3.forEach(view -> view.disconnect(agent));
    }

    @Override
    protected void addChannels(AgentInfo agent, Map<String, AgentChannel> channels) {
        this.children3.forEach(view -> view.addChannels(agent, channels));
    }

    @Override
    protected void removeChannels(AgentInfo agent, List<String> paths) {
        this.children3.forEach(view -> view.removeChannels(agent, paths));
    }

    @Override
    protected void updateChannels(AgentInfo agent, Map<String, Map.Entry<AgentChannel, List<String>>> channels) {
        this.children3.forEach(view -> view.updateChannels(agent, channels));
    }

    @Override
    public void install(AgentStatusAggregator aggregator) {
        super.install(aggregator);
        this.children1.forEach(view -> view.install(aggregator));
    }

    @Override
    public void uninstall(AgentStatusAggregator aggregator) {
        super.uninstall(aggregator);
        this.children1.forEach(view -> view.uninstall(aggregator));
    }
}

