/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.demo.monitor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.base.panel.PanelManager;
import org.lsst.ccs.gconsole.plugins.demo.monitor.FilterFixed;
import org.lsst.ccs.gconsole.plugins.demo.monitor.FilterOutOfRange;
import org.lsst.ccs.gconsole.plugins.monitor.CompoundView;
import org.lsst.ccs.gconsole.plugins.monitor.ConfigView;
import org.lsst.ccs.gconsole.plugins.monitor.LsstMonitorPlugin;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorView;
import org.lsst.ccs.gconsole.plugins.monitor.TreeView;

public class NewStylePlugin
extends ConsolePlugin {
    private Action actDemo1;
    private Action actDemo2;
    private JComponent page1;
    private MonitorView embeddedView;
    private CompoundView compoundView;

    @Override
    public void initialize() {
        this.actDemo1 = new AbstractAction("Monitor GUI 1"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((Boolean)this.getValue("SwingSelectedKey")).booleanValue()) {
                    NewStylePlugin.this.startDemo1();
                } else {
                    NewStylePlugin.this.stopDemo1();
                }
            }
        };
        this.actDemo1.putValue("SwingSelectedKey", false);
        this.getServices().addMenu(this.actDemo1, "Demo", "Monitoring");
        this.actDemo2 = new AbstractAction("Monitor GUI 2"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((Boolean)this.getValue("SwingSelectedKey")).booleanValue()) {
                    NewStylePlugin.this.startDemo2();
                } else {
                    NewStylePlugin.this.stopDemo2();
                }
            }
        };
        this.actDemo2.putValue("SwingSelectedKey", false);
        this.getServices().addMenu(this.actDemo2, "Demo", "Monitoring");
    }

    private void startDemo1() {
        this.actDemo1.putValue("SwingSelectedKey", true);
        if (this.page1 == null) {
            this.embeddedView = new TreeView();
            this.embeddedView.setFilter(new FilterOutOfRange());
            this.page1 = new JPanel(new BorderLayout());
            this.page1.add((Component)new JLabel("The pnanel below is an embedded view"), "North");
            this.page1.add((Component)this.embeddedView.getPanel(), "Center");
            PanelManager pm = this.getConsole().getPanelManager();
            pm.open((Component)this.page1, "GUI with embedded monitoring view");
            pm.addListener(e -> {
                if (e.hasKey(Panel.OPEN) && !((Boolean)e.getNewValue()).booleanValue()) {
                    this.stopDemo1();
                }
            }, this.page1);
            this.embeddedView.install(this.getConsole().getStatusAggregator());
        }
    }

    private void stopDemo1() {
        this.actDemo1.putValue("SwingSelectedKey", false);
        if (this.page1 != null) {
            JComponent page = this.page1;
            this.page1 = null;
            this.embeddedView.uninstall(this.getConsole().getStatusAggregator());
            this.getConsole().getPanelManager().close(page);
        }
    }

    private void startDemo2() {
        this.actDemo2.putValue("SwingSelectedKey", true);
        if (this.compoundView == null) {
            JPanel page2 = new JPanel(new BorderLayout());
            TreeView treeView = new TreeView();
            page2.add((Component)treeView.getPanel(), "Center");
            ConfigView controlView = new ConfigView();
            page2.add((Component)controlView.getPanel(), "South");
            this.compoundView = new CompoundView(page2);
            this.compoundView.addView(treeView, false);
            this.compoundView.addView(controlView, false);
            this.compoundView.setFilter(FilterFixed.getInstance(1, "NAME", true, AlertState.NOMINAL));
            LsstMonitorPlugin monPlugin = (LsstMonitorPlugin)this.getConsole().getConsoleLookup().lookup(LsstMonitorPlugin.class);
            monPlugin.openPage(this.compoundView);
        }
    }

    private void stopDemo2() {
        this.actDemo2.putValue("SwingSelectedKey", false);
        if (this.compoundView != null) {
            CompoundView view = this.compoundView;
            this.compoundView = null;
            this.getConsole().getPanelManager().close(view.getPanel());
        }
    }
}

