package org.lsst.ccs.gconsole.plugins.monitor;

import javax.swing.JComponent;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.gconsole.agent.AgentStatusAggregator;
import org.lsst.ccs.gconsole.agent.AgentStatusListener;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.base.panel.PanelManager;

/**
 * View of monitoring data.
 * {@code AgentStatusListener} methods are called on the {@code AgentStatusAggregator} thread.
 * All other methods declared by this interface should be called on AWT Event Dispatch Thread.
 *
 * @author onoprien
 */
public interface MonitorView extends AgentStatusListener {
    
// -- Getters and setters : ----------------------------------------------------
    
    /**
     * Returns the graphical component maintained by this view.
     * @return Graphical component to be displayed by the GUI.
     */
    JComponent getPanel();
    
    /**
     * Returns the name of this view.
     * @return  View name.
     */
    default String getName() {
        JComponent panel = getPanel();
        return panel == null ? "" : panel.getName();
    }
    
    /**
     * Sets the name of this view.
     * @param name View name.
     */
    default void setName(String name) {
        JComponent panel = getPanel();
        if (panel != null) panel.setName(name);
    }
    
    AgentChannelsFilter getFilter();
    
    void setFilter(AgentChannelsFilter filter);
    
    /**
     * Returns {@code true} if this view has no content to display at the moment.
     * This can be used report that the view can be closed, for example.
     * The default implementation returns {@code false}.
     * @return 
     */
    default boolean isEmpty() {
        return false;
    }
    
    
// -- Installation : -----------------------------------------------------------
    
    default void install(AgentStatusAggregator aggregator) {
        AgentChannelsFilter filter = getFilter();
        if (filter == null) {
            filter = AgentChannelsFilter.ALL;
            setFilter(filter);
        }
        aggregator.addListener(this, filter);
    }
    
    default void uninstall(AgentStatusAggregator aggregator) {
        aggregator.removeListener(this);
    }
        
}
