package org.lsst.ccs.gconsole.agent;

import java.util.concurrent.CopyOnWriteArrayList;

/**
 * Adapter to simplify implementing {@link AgentChannelsFilter}.
 * Provides machinery for handling listeners.
 *
 * @author onoprien
 */
abstract public class AbstractChannelsFilter implements AgentChannelsFilter {

// -- Fields : -----------------------------------------------------------------
    
    private final CopyOnWriteArrayList<AgentChannelsFilter.Listener> listeners = new CopyOnWriteArrayList<>();

    
// -- Handling listeners : -----------------------------------------------------
    
    @Override
    public void addListener(AgentChannelsFilter.Listener listener) {
        listeners.addIfAbsent(listener);
    }
    
    @Override
    public void removeListener(AgentChannelsFilter.Listener listener) {
        listeners.remove(listener);
    }
    
    protected void notifyListeners() {
        AgentChannelsFilter.Event event = new AgentChannelsFilter.Event(AbstractChannelsFilter.this);
        listeners.forEach(listener -> listener.filterChanged(event));
    }

}
