/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.agent;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.agent.AgentChannel;
import org.lsst.ccs.gconsole.agent.AgentChannelState;
import org.lsst.ccs.gconsole.agent.AgentChannelsDictionary;
import org.lsst.ccs.gconsole.agent.AgentStatusAggregator;
import org.lsst.ccs.gconsole.agent.AgentStatusEvent;
import org.lsst.ccs.gconsole.agent.MutableAgentChannel;
import org.lsst.ccs.gconsole.agent.MutableAgentStatusEvent;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.messaging.CommandRejectedException;
import org.lsst.ccs.subsystem.monitor.data.MonitorChan;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;
import org.lsst.ccs.subsystem.monitor.data.MonitorState;

class AgentHandle {
    private final AgentInfo agentInfo;
    private final AgentStatusAggregator aggregator;
    private final ArrayList<ListenerHandle> listeners = new ArrayList(0);
    HashMap<String, String> state;
    Instant stateTime;
    LinkedHashMap<String, MutableAgentChannel> channels;
    HashSet<String> rejectedPaths;
    volatile Instant dictTime;
    AgentChannelsDictionary dictionary;
    MonitorState monitorState;
    Instant monitorStateTime;

    AgentHandle(AgentInfo agentInfo, AgentStatusAggregator aggregator) {
        this.aggregator = aggregator;
        this.agentInfo = agentInfo;
    }

    boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    AgentInfo getAgent() {
        return this.agentInfo;
    }

    MutableAgentChannel getChannel(String innerPath) {
        return this.channels == null ? null : this.channels.get(innerPath);
    }

    Collection<MutableAgentChannel> getChannels() {
        return this.channels == null ? Collections.emptyList() : this.channels.values();
    }

    void onConnect(StatusMessage message) {
        this.state = new HashMap(message.getState().getAllStatesAsStrings());
        this.stateTime = message.getState().getLastModified();
        this.aggregator.listeners.forEach(globalHandle -> this.createLocalListenerHangle((AgentStatusAggregator.GlobalListenerHandle)globalHandle));
        this.listeners.trimToSize();
        AgentStatusEvent event = new AgentStatusEvent(this.aggregator, this.agentInfo);
        this.listeners.forEach(lh -> lh.global.listener.connect(event));
    }

    void onConfiguration(Object data) {
        ArrayList<MutableAgentChannel> allChannels = new ArrayList<MutableAgentChannel>();
        if (data instanceof MonitorFullState) {
            MonitorFullState mfs = (MonitorFullState)data;
            List mChannels = mfs.getChannels();
            MutableAgentChannel[] chs = new MutableAgentChannel[mChannels.size()];
            for (int i = 0; i < chs.length; ++i) {
                MonitorChan mc = (MonitorChan)mChannels.get(i);
                chs[i] = new MutableAgentChannel(this.agentInfo.getName() + "/" + mc.getName(), this.agentInfo);
                chs[i].set(mc.getValue());
                chs[i].set(MonitorField.UNITS.name(), mc.getUnits());
                chs[i].set(MonitorField.DESCR.name(), mc.getDescription());
                chs[i].set(MonitorField.ALERT_HIGH.name(), mc.getHighAlarm());
                chs[i].set(MonitorField.ALERT_LOW.name(), mc.getLowAlarm());
                chs[i].set(MonitorField.HIGH.name(), mc.getHighLimit());
                chs[i].set(MonitorField.HIGH_WARN.name(), mc.getHighWarning());
                chs[i].set(MonitorField.LOW.name(), mc.getLowLimit());
                chs[i].set(MonitorField.LOW_WARN.name(), mc.getLowWarning());
                chs[i].set("MONITOR_ID", i);
                String page = (String)mfs.getPages().get(mc.getPage());
                if (page != null) {
                    chs[i].set("MONITOR_PAGE", page);
                }
                chs[i].set("MONITOR_FORMAT", mc.getFormat());
                chs[i].set("MONITOR_STATE", AgentChannelState.packMonitorState(mfs.getMonitorState(), i));
            }
            this.monitorState = mfs.getMonitorState();
            this.monitorStateTime = Instant.MIN;
            allChannels.addAll(Arrays.asList(chs));
        } else {
            this.monitorStateTime = Instant.MAX;
        }
        for (Map.Entry<String, String> e : this.state.entrySet()) {
            MutableAgentChannel channel = new MutableAgentChannel(this.agentInfo.getName() + "/state/" + e.getKey(), this.agentInfo);
            channel.set("state", true);
            channel.set(e.getValue());
            allChannels.add(channel);
        }
        allChannels.trimToSize();
        this.dictionary = new AgentChannelsDictionary(allChannels);
        this.dictTime = null;
        this.listeners.forEach(lh -> lh.processDictionary());
        this.resetRejectedPaths();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMessage(StatusMessage mess) {
        if (this.listeners.isEmpty()) {
            return;
        }
        if (this.dictionary == null && this.channels != null) {
            this.requestDictionary();
        }
        MutableAgentStatusEvent event = new MutableAgentStatusEvent(this.aggregator, mess);
        AgentHandle agentHandle = this;
        synchronized (agentHandle) {
            StatusSubsystemData sd;
            String key;
            Object o;
            String innerPath;
            Instant messTimeStamp = Instant.ofEpochMilli(mess.getTimeStamp());
            Instant stateTimeStamp = mess.getState().getLastModified();
            if (this.channels == null || this.dictionary == null) {
                if (!this.stateTime.isAfter(stateTimeStamp)) {
                    this.state = new HashMap(mess.getState().getAllStatesAsStrings());
                    this.stateTime = mess.getState().getLastModified();
                }
                return;
            }
            if (!this.stateTime.isAfter(stateTimeStamp)) {
                Map current = mess.getState().getAllStatesAsStrings();
                for (Map.Entry e : current.entrySet()) {
                    String newValue;
                    String key2 = (String)e.getKey();
                    String oldValue = this.state.get(key2);
                    if (Objects.equals(oldValue, newValue = (String)e.getValue())) continue;
                    this.state.put(key2, newValue);
                    innerPath = "state/" + (String)e.getKey();
                    MutableAgentChannel channel = this.channels.get(innerPath);
                    if (channel == null) {
                        channel = this.createChannel(innerPath);
                        if (channel == null) continue;
                        channel.set("state", true);
                        channel.set(newValue);
                        event.addAddedChannel(channel);
                        continue;
                    }
                    boolean changed = channel.set(newValue);
                    if (!changed) continue;
                    event.addChange(channel, "value");
                }
                this.stateTime = stateTimeStamp;
            }
            if ((o = mess.getEncodedData()) instanceof KeyValueDataList) {
                KeyValueDataList encodedData = (KeyValueDataList)o;
                for (KeyValueData d : encodedData) {
                    KeyValueData.KeyValueDataType type = d.getType();
                    String attrKey = null;
                    innerPath = null;
                    switch (type) {
                        case KeyValueTrendingData: {
                            innerPath = d.getKey();
                            attrKey = "value";
                            break;
                        }
                        case KeyValueMetaData: {
                            innerPath = d.getKey();
                            int lastIndex = innerPath.lastIndexOf(47);
                            attrKey = innerPath.substring(lastIndex + 1);
                            innerPath = innerPath.substring(0, lastIndex);
                        }
                    }
                    if (attrKey == null) continue;
                    Serializable value = d.getValue();
                    MutableAgentChannel channel = this.channels.get(innerPath);
                    if (channel == null) {
                        channel = this.createChannel(innerPath);
                        if (channel == null) continue;
                        channel.set(attrKey, value);
                        event.addAddedChannel(channel);
                        continue;
                    }
                    boolean changed = channel.set(attrKey, value);
                    if (!changed) continue;
                    event.addChange(channel, attrKey);
                }
            }
            if (mess instanceof StatusSubsystemData && !this.monitorStateTime.isAfter(messTimeStamp) && (key = (sd = (StatusSubsystemData)mess).getDataKey()).equals("MonitorState")) {
                try {
                    MonitorState current = (MonitorState)sd.getSubsystemData().getValue();
                    MonitorState prev = this.monitorState;
                    prev.getGoodChans().xor(current.getGoodChans());
                    BitSet change = (BitSet)prev.getGoodChans().clone();
                    prev.getOnlineChans().xor(current.getOnlineChans());
                    change.or(prev.getOnlineChans());
                    prev.getLowLimitChange().xor(current.getLowLimitChange());
                    change.or(prev.getLowLimitChange());
                    prev.getHighLimitChange().xor(current.getHighLimitChange());
                    change.or(prev.getHighLimitChange());
                    int i = change.nextSetBit(0);
                    while (i != -1) {
                        String path = this.dictionary.getAll().get(i).getLocalPath();
                        MutableAgentChannel channel = this.channels.get(path);
                        if (channel != null) {
                            channel.set("MONITOR_STATE", AgentChannelState.packMonitorState(current, i));
                            event.addChange(channel, "MONITOR_STATE");
                        }
                        i = change.nextSetBit(i + 1);
                    }
                    this.monitorState = current;
                }
                catch (RuntimeException x) {
                    System.out.println("Failed to get monitor state: " + x);
                }
            }
        }
        if (!event.getAddedChannels().isEmpty() || !event.getRemovedChannels().isEmpty()) {
            this.resetRejectedPaths();
        }
        if (!(event.getStatusChanges().isEmpty() && event.getAddedChannels().isEmpty() && event.getRemovedChannels().isEmpty())) {
            this.listeners.forEach(lh -> {
                AgentStatusEvent e = event.filter(lh.paths);
                if (!e.isEmpty()) {
                    lh.global.listener.statusChanged(e);
                }
            });
        }
    }

    void onDisconnect(StatusMessage mess) {
        ArrayList<AgentChannel> removed = this.channels == null ? Collections.emptyList() : new ArrayList<AgentChannel>(this.channels.values());
        AgentStatusEvent event = new AgentStatusEvent(this.aggregator, this.agentInfo, Collections.emptyMap(), Collections.emptyList(), removed);
        this.listeners.forEach(lh -> {
            AgentStatusEvent e = event.filter(lh.paths);
            if (!e.isEmpty()) {
                lh.global.listener.disconnect(e);
            }
        });
    }

    void addListener(AgentStatusAggregator.GlobalListenerHandle global) {
        ListenerHandle localHandle = this.createLocalListenerHangle(global);
        if (localHandle != null) {
            global.listener.connect(new AgentStatusEvent(this.aggregator, this.agentInfo));
            if (localHandle.paths != null) {
                if (this.dictionary == null) {
                    this.requestDictionary();
                } else {
                    localHandle.processDictionary();
                    this.resetRejectedPaths();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(AgentStatusAggregator.GlobalListenerHandle global) {
        Iterator<ListenerHandle> it = this.listeners.iterator();
        boolean changed = false;
        while (it.hasNext()) {
            ListenerHandle local = it.next();
            if (local.global != global) continue;
            it.remove();
            changed = true;
        }
        if (changed) {
            HashSet<String> paths = null;
            for (ListenerHandle lh : this.listeners) {
                if (lh.paths == null) continue;
                if (paths == null) {
                    paths = new HashSet<String>();
                }
                paths.addAll(lh.paths);
            }
            AgentHandle agentHandle = this;
            synchronized (agentHandle) {
                if (paths == null) {
                    this.channels = null;
                } else {
                    Iterator<Map.Entry<String, MutableAgentChannel>> iter = this.channels.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry<String, MutableAgentChannel> e = iter.next();
                        if (paths.contains(e.getKey())) continue;
                        iter.remove();
                    }
                }
            }
            this.resetRejectedPaths();
        }
    }

    void requestDictionary() {
        Duration timeout = Duration.ofSeconds(60L);
        if (this.dictionary == null && (this.dictTime == null || Instant.now().minus(timeout).isAfter(this.dictTime))) {
            this.dictTime = Instant.now();
            CommandRequest cmd = new CommandRequest(this.agentInfo.getName(), "getMonitorFullState");
            Runnable task = () -> {
                try {
                    Object result;
                    block4: {
                        result = null;
                        try {
                            result = this.aggregator.getMessenger().sendSynchronousCommand(cmd, timeout);
                        }
                        catch (CommandRejectedException x) {
                            if (x.getCommandNack().getReason().contains("Could not find command")) break block4;
                            throw x;
                        }
                    }
                    Object dictData = result;
                    this.dictTime = Instant.MAX;
                    this.aggregator.exec.execute(() -> {
                        if (this.dictionary == null && !this.listeners.isEmpty()) {
                            this.onConfiguration(dictData);
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            };
            Thread thread = new Thread(task, "Fetching channels dictionary from " + this.agentInfo.getName());
            thread.setDaemon(true);
            thread.run();
        }
    }

    MutableAgentChannel createChannel(String innerPath) {
        if (this.rejectedPaths == null || this.rejectedPaths.contains(innerPath)) {
            return null;
        }
        boolean accept = false;
        block0: for (ListenerHandle lh : this.listeners) {
            if (lh.paths == null) continue;
            if (lh.paths.contains(innerPath)) {
                accept = true;
                continue;
            }
            for (String template : lh.templates) {
                if (!innerPath.startsWith(template)) continue;
                accept = true;
                lh.paths.add(innerPath);
                continue block0;
            }
        }
        if (accept) {
            MutableAgentChannel channel = new MutableAgentChannel(this.agentInfo.getName() + "/" + innerPath, this.agentInfo);
            this.channels.put(innerPath, channel);
            return channel;
        }
        this.rejectedPaths.add(innerPath);
        return null;
    }

    private ListenerHandle createLocalListenerHangle(AgentStatusAggregator.GlobalListenerHandle globalHandle) {
        ListenerHandle localHandle = null;
        if (globalHandle.agents == null || globalHandle.agents.contains(this.agentInfo.getName())) {
            localHandle = new ListenerHandle(globalHandle);
            if (globalHandle.channels == null) {
                localHandle.paths = new HashSet<String>();
            } else {
                String prefix = this.agentInfo.getName() + "/";
                for (String s : globalHandle.channels) {
                    if (AgentHandle.isSelector(s)) {
                        String a = AgentHandle.parseSelector(s).get("agent.name");
                        if (a != null && !this.agentInfo.getName().equals(a)) continue;
                        localHandle.paths = new HashSet<String>();
                    } else {
                        if (!s.startsWith(prefix) && !s.startsWith("/")) continue;
                        localHandle.paths = new HashSet<String>();
                    }
                    break;
                }
            }
        } else if (globalHandle.channels != null) {
            String prefix = this.agentInfo.getName() + "/";
            for (String s : globalHandle.channels) {
                if (AgentHandle.isSelector(s)) {
                    String a = AgentHandle.parseSelector(s).get("agent.name");
                    if (!this.agentInfo.getName().equals(a)) continue;
                    localHandle = new ListenerHandle(globalHandle);
                    localHandle.paths = new HashSet<String>();
                } else {
                    if (!s.startsWith(prefix)) continue;
                    localHandle = new ListenerHandle(globalHandle);
                    localHandle.paths = new HashSet<String>();
                }
                break;
            }
        }
        if (localHandle != null) {
            this.listeners.add(localHandle);
            if (localHandle.paths != null) {
                if (this.channels == null) {
                    this.channels = new LinkedHashMap();
                }
                if (this.dictionary == null) {
                    this.requestDictionary();
                }
            }
        }
        return localHandle;
    }

    private void resetRejectedPaths() {
        this.rejectedPaths = null;
        if (this.channels == null) {
            return;
        }
        for (ListenerHandle lh : this.listeners) {
            if (lh.paths == null) continue;
            if (lh.templates.isEmpty()) {
                for (String localPath : lh.paths) {
                    if (this.channels.containsKey(localPath)) continue;
                    this.rejectedPaths = new HashSet();
                    return;
                }
                continue;
            }
            this.rejectedPaths = new HashSet();
            return;
        }
    }

    static boolean isSelector(String s) {
        if (s.contains("=")) {
            return true;
        }
        return !s.contains("/");
    }

    static boolean acceptSelector(AgentChannel channel, String selector) {
        for (String condition : selector.split("&")) {
            Object value;
            String[] ss = condition.split("=");
            String key = ss[0];
            if (key.startsWith("agent.")) {
                switch (key = key.substring("agent.".length())) {
                    case "name": {
                        value = channel.getAgentName();
                        break;
                    }
                    case "type": {
                        value = channel.getAgent().getType();
                        break;
                    }
                    default: {
                        value = channel.get(key);
                        break;
                    }
                }
            } else {
                value = channel.get(key);
            }
            if (!(ss.length == 1 ? value == null : (value == null ? !"null".equals(ss[1]) : !value.toString().equals(ss[1])))) continue;
            return false;
        }
        return true;
    }

    static Map<String, String> parseSelector(String selector) {
        String[] ss = selector.split("&");
        LinkedHashMap<String, String> out = new LinkedHashMap<String, String>(ss.length * 2);
        for (String s : ss) {
            String[] tt = s.split("=");
            out.put(tt[0], tt.length == 1 ? null : tt[1]);
        }
        return out;
    }

    static boolean matchTemplate(String path, String template) {
        if (template.startsWith("/")) {
            path = path.substring(path.indexOf("/"));
        }
        return template.endsWith("/") ? path.startsWith(template) : path.equals(template);
    }

    static boolean matchLocalTemplate(String localPath, String localTemplate) {
        if (localTemplate.isEmpty()) {
            return true;
        }
        return localTemplate.endsWith("/") ? localPath.startsWith(localTemplate) : localPath.equals(localTemplate);
    }

    private class ListenerHandle {
        AgentStatusAggregator.GlobalListenerHandle global;
        Set<String> paths;
        List<String> templates;

        ListenerHandle(AgentStatusAggregator.GlobalListenerHandle global) {
            this.global = global;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        void processDictionary() {
            if (this.paths == null) {
                return;
            }
            this.templates = new ArrayList<String>();
            boolean inAgentList = this.global.agents == null || this.global.agents.contains(AgentHandle.this.agentInfo.getName());
            String prefix = AgentHandle.this.agentInfo.getName() + "/";
            for (String string : this.global.channels) {
                void var4_8;
                if (AgentHandle.isSelector(string)) {
                    for (MutableAgentChannel channel : AgentHandle.this.dictionary.getAll()) {
                        if (!AgentHandle.acceptSelector(channel, string)) continue;
                        this.paths.add(channel.getLocalPath());
                    }
                    continue;
                }
                if (string.startsWith(prefix)) {
                    String string2 = string.substring(prefix.length());
                } else {
                    if (!inAgentList || !string.startsWith("/")) continue;
                    String string3 = string.substring(1);
                }
                if (var4_8.endsWith("/") || var4_8.isEmpty()) {
                    this.templates.add((String)var4_8);
                    continue;
                }
                this.paths.add((String)var4_8);
            }
            ArrayList<AgentChannel> added = new ArrayList<AgentChannel>();
            AgentHandle agentHandle = AgentHandle.this;
            synchronized (agentHandle) {
                block5: for (MutableAgentChannel channel : AgentHandle.this.dictionary.getAll()) {
                    String localPath = channel.getLocalPath();
                    if (this.paths.contains(localPath)) {
                        AgentHandle.this.channels.put(localPath, channel);
                        added.add(channel);
                        continue;
                    }
                    for (String template : this.templates) {
                        if (!localPath.startsWith(template)) continue;
                        this.paths.add(localPath);
                        AgentHandle.this.channels.put(localPath, channel);
                        added.add(channel);
                        continue block5;
                    }
                }
            }
            if (this.templates.isEmpty()) {
                this.templates = Collections.emptyList();
            } else {
                ((ArrayList)this.templates).trimToSize();
            }
            this.paths = new HashSet<String>(this.paths);
            AgentStatusEvent agentStatusEvent = new AgentStatusEvent(AgentHandle.this.aggregator, AgentHandle.this.agentInfo, null, added, null);
            this.global.listener.configure(agentStatusEvent);
        }
    }
}

