/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigurationDescription
implements Serializable {
    private static final long serialVersionUID = 2262886830605244842L;
    public static final String DEFAULT_CONFIG_NAME = "";
    public static final String DEFAULT_CAT = "";
    public static final String SAFE_CONFIG_NAME = "safe";
    private static final String DEFAULT_V_STRING = "d";
    private static final String LATEST_V_STRING = "l";
    private static final String UNDEF_V_STRING = "u";
    private static final Pattern configInputPattern = Pattern.compile("((.*?)[:])?(.*?)([(]{1}?(([0-9]*|l|d|u))[)]{1})?");
    private String name = null;
    private int version = -3;
    private final Set<String> categories;
    private final Map<String, String> categoryTags = new HashMap<String, String>();
    private final Map<String, Integer> categoryVersions = new HashMap<String, Integer>();

    public ConfigurationDescription() {
        this.categories = null;
    }

    public ConfigurationDescription(Set<String> categories) {
        this.categories = new HashSet<String>(categories);
    }

    public static ConfigurationDescription safeConfiguration(Set<String> categories) {
        ConfigurationDescription res = new ConfigurationDescription(categories);
        for (String cat : categories) {
            res.putTagForCategory(cat, SAFE_CONFIG_NAME, null);
        }
        return res;
    }

    public ConfigurationDescription parseConfigurationString(String ... taggedCategories) {
        if (taggedCategories == null || taggedCategories.length == 0) {
            return this;
        }
        for (String s : taggedCategories) {
            Matcher m = configInputPattern.matcher(s);
            if (!m.matches()) {
                throw new IllegalArgumentException("wrong configuration string representation : " + s);
            }
            String cat = m.group(2) == null ? "" : m.group(2);
            String tag = m.group(3) == null ? "" : m.group(3);
            String v = m.group(5);
            int ver = v == null || v.isEmpty() || v.equals(DEFAULT_V_STRING) ? -1 : (v.equals(LATEST_V_STRING) ? -2 : (v.equals(UNDEF_V_STRING) ? -3 : Integer.valueOf(v)));
            this.putTagForCategory(cat, tag, ver);
        }
        return this;
    }

    public ConfigurationDescription withDefaults(boolean withDefaults) {
        if (withDefaults) {
            for (String cat : this.categories) {
                if (this.categoryTags.containsKey(cat)) continue;
                this.putTagForCategory(cat, "", -1);
            }
        }
        return this;
    }

    public void putTagForCategory(String cat, String tag, Integer version) {
        if (this.categories != null && !this.categories.contains(cat)) {
            throw new IllegalArgumentException("unexisting category " + cat);
        }
        this.categoryTags.put(cat, tag);
        this.categoryVersions.put(cat, version);
    }

    public Map<String, String> getCategoryTags() {
        return Collections.unmodifiableMap(this.categoryTags);
    }

    public Map<String, Integer> getCategoryVersions() {
        return Collections.unmodifiableMap(this.categoryVersions);
    }

    public boolean isEmpty() {
        return this.categoryTags.isEmpty();
    }

    public boolean containsCategory(String category) {
        return this.categoryTags.containsKey(category);
    }

    public void merge(ConfigurationDescription configDesc) {
        for (Map.Entry<String, String> tags : configDesc.categoryTags.entrySet()) {
            this.categoryTags.put(tags.getKey(), tags.getValue());
            if (this.categoryTags.get(tags.getKey()).equals(configDesc.categoryTags.get(tags.getKey()))) continue;
            this.categoryVersions.put(tags.getValue(), null);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getVersion() {
        return this.version;
    }

    public void setName(String name, int version) {
        this.name = name;
        this.version = version;
    }

    private String getVersionAsString(String cat) {
        Integer ver = this.categoryVersions.get(cat);
        if (ver == null) {
            return UNDEF_V_STRING;
        }
        switch (ver) {
            case -3: {
                return UNDEF_V_STRING;
            }
            case -2: {
                return LATEST_V_STRING;
            }
            case -1: {
                return DEFAULT_V_STRING;
            }
        }
        return String.valueOf(ver);
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.categories);
        hash = 89 * hash + Objects.hashCode(this.categoryTags);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigurationDescription other = (ConfigurationDescription)obj;
        return this.categoryTags.equals(other.categoryTags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(0);
        for (Map.Entry<String, String> e : this.categoryTags.entrySet()) {
            sb.append(e.getKey()).append(":").append(e.getValue()).append("(").append(this.getVersionAsString(e.getKey())).append(")").append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }
}

