/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.gconsole.agent.AgentChannel;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.gconsole.agent.AgentStatusEvent;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorView;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;

public abstract class AbstractMonitorView
implements MonitorView {
    protected AgentChannelsFilter filter;
    private boolean fixedDisplayList;
    private Set<String> displayChannels;

    @Override
    public JComponent getPanel() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public AgentChannelsFilter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(AgentChannelsFilter filter) {
        this.filter = filter;
        this.fixedDisplayList = filter != null && filter.getDisplayChannels() != null;
    }

    protected boolean isChannelListFixed() {
        return this.fixedDisplayList;
    }

    @Override
    public void connect(AgentStatusEvent event) {
        SwingUtilities.invokeLater(() -> this.connect(event.getSource()));
    }

    @Override
    public void configure(AgentStatusEvent event) {
        if (this.displayChannels == null) {
            List<String> fixed = this.filter.getDisplayChannels();
            if (fixed == null) {
                this.fixedDisplayList = false;
                this.displayChannels = Collections.emptySet();
            } else {
                this.fixedDisplayList = true;
                this.displayChannels = new HashSet<String>(fixed);
                SwingUtilities.invokeLater(() -> this.addChannels(event.getSource(), fixed.stream().collect(Collectors.toMap(dp -> dp, dp -> null))));
            }
        }
        this.update(event);
    }

    @Override
    public void statusChanged(AgentStatusEvent event) {
        this.update(event);
    }

    @Override
    public void disconnect(AgentStatusEvent event) {
        this.update(event);
        SwingUtilities.invokeLater(() -> this.disconnect(event.getSource()));
    }

    /*
     * WARNING - void declaration
     */
    private void update(AgentStatusEvent event) {
        if (this.fixedDisplayList) {
            LinkedHashMap<String, Map.Entry> changedChannels = new LinkedHashMap<String, Map.Entry>();
            for (AgentChannel agentChannel : event.getAddedChannels()) {
                for (String string : this.filter.getDisplayPath(agentChannel)) {
                    if (!this.displayChannels.contains(string)) continue;
                    changedChannels.put(string, new AbstractMap.SimpleEntry<AgentChannel, Object>(agentChannel, null));
                }
            }
            for (AgentChannel agentChannel : event.getRemovedChannels()) {
                for (String string : this.filter.getDisplayPath(agentChannel)) {
                    if (!this.displayChannels.contains(string)) continue;
                    changedChannels.put(string, null);
                }
            }
            for (Map.Entry entry : event.getStatusChanges().entrySet()) {
                for (String string : this.filter.getDisplayPath((AgentChannel)entry.getKey())) {
                    if (!this.displayChannels.contains(string)) continue;
                    changedChannels.put(string, entry);
                }
            }
            SwingUtilities.invokeLater(() -> this.updateChannels(event.getSource(), changedChannels));
        } else {
            void var4_14;
            LinkedHashMap<String, AgentChannel> addedChannels = null;
            for (AgentChannel agentChannel : event.getAddedChannels()) {
                for (String string : this.filter.getDisplayPath(agentChannel)) {
                    if (addedChannels == null) {
                        addedChannels = new LinkedHashMap<String, AgentChannel>();
                    }
                    addedChannels.put(string, agentChannel);
                }
            }
            ArrayList<String> removedChannels = null;
            for (AgentChannel agentChannel : event.getRemovedChannels()) {
                for (String string : this.filter.getDisplayPath(agentChannel)) {
                    if (removedChannels == null) {
                        removedChannels = new ArrayList<String>(event.getRemovedChannels().size());
                    }
                    removedChannels.add(string);
                }
            }
            Object var4_13 = null;
            for (Map.Entry<AgentChannel, List<String>> entry : event.getStatusChanges().entrySet()) {
                for (String displayPath : this.filter.getDisplayPath(entry.getKey())) {
                    if (var4_14 == null) {
                        LinkedHashMap linkedHashMap = new LinkedHashMap();
                    }
                    var4_14.put(displayPath, entry);
                }
            }
            LinkedHashMap<String, AgentChannel> linkedHashMap = addedChannels;
            ArrayList<String> arrayList = removedChannels;
            void var7_40 = var4_14;
            SwingUtilities.invokeLater(() -> this.lambda$update$6(linkedHashMap, event, arrayList, (Map)var7_40));
        }
    }

    protected void connect(AgentInfo agent) {
    }

    protected void disconnect(AgentInfo agent) {
    }

    protected void addChannels(AgentInfo agent, Map<String, AgentChannel> channels) {
    }

    protected void removeChannels(AgentInfo agent, List<String> paths) {
    }

    protected void updateChannels(AgentInfo agent, Map<String, Map.Entry<AgentChannel, List<String>>> channels) {
    }

    protected final Object sendCommand(Duration timeout, String dest, String target, String cmnd, Object ... args) throws Exception {
        ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(Console.getConsole().getMessagingAccess());
        String dst = dest + (target == null ? "" : "/" + target);
        CommandRequest cmd = new CommandRequest(dst, cmnd, args);
        return cmu.sendSynchronousCommand(cmd, timeout);
    }

    protected final void sendCommand(String dest, String target, String cmnd, Object ... args) {
        Thread t = new Thread(() -> {
            try {
                this.sendCommand(Duration.ofSeconds(1L), dest, target, cmnd, args);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, "Temporary thread for sending a command");
        t.start();
    }
}

