/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.description;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.utilities.logging.Logger;

public class ComponentNode<T extends ComponentNode<T>>
implements Serializable {
    private static final long serialVersionUID = 284121597899337112L;
    public static final Logger logger = Logger.getLogger((String)"org.lsst.ccs.description");
    protected final Map tags = new HashMap();
    private String key;
    private ComponentNode<T> parent;
    private final List<T> children = new ArrayList<T>();
    private Object component;
    private String protocol;

    public ComponentNode(T parent, String name) {
        this(parent, name, null);
    }

    public ComponentNode(T parent, String name, Object component) {
        this.parent = parent;
        this.key = name;
        this.component = component;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public Object getComponent() {
        return this.component;
    }

    public void setComponent(Object component) {
        if (this.component != null) {
            throw new RuntimeException("Cannot set component twice.");
        }
        this.component = component;
    }

    void setParent(ComponentNode<T> parent) {
        this.parent = parent;
    }

    public String getKey() {
        return this.key;
    }

    public List<T> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void addChild(T child) throws NullPointerException {
        ((ComponentNode)child).setParent(this);
        this.children.add(child);
    }

    public String toString() {
        String valueString;
        try {
            valueString = String.valueOf(this.component);
        }
        catch (Exception exc) {
            valueString = "can't trace value [" + exc + "] ";
        }
        return String.valueOf(this.key) + "(" + valueString + ") {" + String.valueOf(this.children) + "}";
    }

    public ComponentNode<T> getParent() {
        return this.parent;
    }

    public void addTag(String key, Object value) {
        this.tags.put(key, value);
    }

    public Object getTag(String key) {
        return this.tags.get(key);
    }

    public Map getTags() {
        return this.tags;
    }
}

