/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.monitor;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.DataProviderState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Line;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.monitor.MonitorLogUtils;

public class Alarm
implements HasLifecycle {
    public static final int EVENT_TRIP = 0;
    public static final int EVENT_LIMBO = 1;
    public static final int EVENT_LIMBO_FROM_ERROR = 1;
    public static final int EVENT_LIMBO_FROM_GOOD = 2;
    public static final int EVENT_RESET = 3;
    private String alarmCause;
    private final Map<Channel, DataProviderState> channelStates = new HashMap<Channel, DataProviderState>();
    protected String description = " ";
    protected String lineName;
    protected int eventParm;
    private Line line;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Monitor mon;
    private DataProviderState state = DataProviderState.NOMINAL;
    private DataProviderState newState = DataProviderState.OFF_LINE;
    private final Object updateStateLock = new Object();
    @LookupName
    protected String name;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem s;

    void configure() {
        try {
            if (this.lineName != null) {
                this.line = this.mon.getLine(this.lineName);
                if (this.line == null) {
                    MonitorLogUtils.reportError(this.s.getLogger(), this.name, "line", this.lineName);
                } else {
                    this.line.set(false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void updateState(Channel ch, DataProviderState value, String cause) {
        DataProviderState channelLastState = this.channelStates.get(ch);
        if (channelLastState == null || channelLastState != value) {
            this.alarmCause = this.alarmCause + cause + "\n";
            this.channelStates.put(ch, value);
        }
        if (value.ordinal() > this.newState.ordinal()) {
            this.newState = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setState() {
        Object object = this.updateStateLock;
        synchronized (object) {
            if (this.newState != this.state) {
                Boolean set = null;
                Integer event = null;
                if (this.newState == DataProviderState.ALARM) {
                    set = true;
                    event = 0;
                } else if (this.state == DataProviderState.ALARM) {
                    set = false;
                    event = this.newState == DataProviderState.NOMINAL ? 3 : 1;
                } else if (this.newState == DataProviderState.NOMINAL) {
                    event = 3;
                } else if (this.newState == DataProviderState.WARNING) {
                    event = 2;
                }
                if (this.line != null && set != null) {
                    this.line.set(set);
                }
                if (this.eventParm >= 0 && event != null) {
                    for (Monitor.AlarmHandler alarmHandler : this.mon.getAlarmHandlersList()) {
                        if (alarmHandler.processAlarm(event, this.eventParm, this.alarmCause, this.name)) break;
                    }
                }
                this.state = this.newState;
            }
        }
        this.newState = DataProviderState.NOMINAL;
        this.alarmCause = "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearState() {
        Object object = this.updateStateLock;
        synchronized (object) {
            this.state = DataProviderState.NOMINAL;
        }
    }

    String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }
}

