/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.agent.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.lsst.ccs.gconsole.agent.AbstractChannelsFilter;
import org.lsst.ccs.gconsole.annotations.ConsoleLookup;

@ConsoleLookup(id="org.lsst.ccs.gconsole.agent.AgentChannelsFilter", name="Explicit Lists", path="Built-In/Generic", description="Channels filter that allows the user to specify lists of accepted agents and channels.Optional parameters: <dl><dt>name</dt><dd>Filter name.</dd><dt>agents</dt><dd>Comma-separated list of subsystems accepted by this filter.</dd><dt>channels</dt><dd>Comma-separated list of channels accepted by this filter (may contain templates and selectors).</dd><dt>delimeter</dt><dd>Character in the original channel path that should be replaced by a slash (and therefore used as a path delimeter).</dd><dt>separatePagesForAgents</dt><dd>If true, the subsystem name is used as a page name.</dd></dl>")
public class GenericFilter
extends AbstractChannelsFilter {
    private final String name;
    private final List<String> agents;
    private final List<String> channels;
    private final String delimeter;
    private final boolean agentTabs;
    private HashMap<String, String> display2origin;

    public GenericFilter(String name, String agents, String channels, String delimeter, boolean separatePagesForAgents) {
        String[] ss;
        this.name = name;
        if (agents.trim().isEmpty()) {
            this.agents = null;
        } else if (agents.trim().equals("\"\"")) {
            this.agents = Collections.emptyList();
        } else {
            ss = agents.split(",");
            this.agents = new ArrayList<String>(ss.length);
            for (String s : ss) {
                this.agents.add(s.trim());
            }
        }
        if (channels.trim().isEmpty()) {
            this.channels = null;
        } else if (channels.trim().equals("\"\"")) {
            this.channels = Collections.emptyList();
        } else {
            ss = channels.split(",");
            this.channels = new ArrayList<String>(ss.length);
            for (String s : ss) {
                this.channels.add(s.trim());
            }
        }
        if (delimeter.trim().isEmpty()) {
            this.delimeter = null;
        } else {
            this.delimeter = delimeter;
            this.display2origin = new HashMap();
        }
        this.agentTabs = separatePagesForAgents;
    }

    @Override
    public List<String> getDisplayPath(String originPath) {
        String displayPath;
        if (this.delimeter == null) {
            displayPath = this.agentTabs ? originPath.replaceFirst("/", "//") : originPath;
        } else {
            int i = originPath.indexOf("/");
            String agent = originPath.substring(0, i);
            String localPath = originPath.substring(i + 1);
            localPath = localPath.replaceAll(this.delimeter, "/");
            displayPath = this.agentTabs ? agent + "//" + localPath : agent + "/" + localPath;
            this.display2origin.putIfAbsent(displayPath, originPath);
        }
        return Collections.singletonList(displayPath);
    }

    @Override
    public String getOriginPath(String displayPath) {
        if (this.delimeter == null) {
            if (this.agentTabs) {
                return displayPath.replaceFirst("//", "/");
            }
            return displayPath;
        }
        return this.display2origin.get(displayPath);
    }

    @Override
    public List<String> getOriginChannels() {
        return this.channels;
    }

    @Override
    public List<String> getAgents() {
        return this.agents;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

