/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.states;

import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.gconsole.plugins.states.SubsystemStatesTableModel;
import org.lsst.ccs.messaging.StatusMessageListener;

public class SubsystemStatesChangeListener
implements StatusMessageListener {
    private final String subsystem;
    private volatile boolean initialized = false;
    private final SubsystemStatesTableModel model;
    private final Object lock = new Object();

    public SubsystemStatesChangeListener(String subsystem, SubsystemStatesTableModel model) {
        this.subsystem = subsystem;
        this.model = model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStatusMessage(StatusMessage msg) {
        if (!this.initialized) {
            Object object = this.lock;
            synchronized (object) {
                StateBundle s = msg.getState();
                this.model.updateRow(this.subsystem, s);
                this.initialized = true;
            }
        }
        if (msg instanceof StatusStateChangeNotification) {
            Object object = this.lock;
            synchronized (object) {
                StatusStateChangeNotification sscn = (StatusStateChangeNotification)msg;
                this.model.updateRow(this.subsystem, sscn.getNewState());
            }
        }
    }

    String getSubsystem() {
        return this.subsystem;
    }

    void disable() {
    }
}

