package org.lsst.ccs.gconsole.plugins.states;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.CommandState;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.bus.states.StateBundle;

/**
 * Table model for Subsystem states
 * @author The LSST CCS Team
 */
public class SubsystemStatesTableModel extends DefaultTableModel {

    private final Map<String,Integer> existingRows = new HashMap<>();
    private final static String[] defaultStates = new String[] {"Phase","Command","Operational","Alert","Configuration"};
    
    
    public SubsystemStatesTableModel() {
        super();
        addColumn("Agent");
        for (String col : defaultStates) {
            addColumn(col);
        }
    }

    
    
    
    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }
    
    synchronized void updateRow(String subsystem, StateBundle sb) {
        Vector row = convertStateBundle(subsystem, sb);
        if ( !existingRows.containsKey(subsystem) ) {
            addRow(row);
            existingRows.put(subsystem,getRowCount()-1);
        } else {
            int rowIndex = existingRows.get(subsystem);
            for ( int colIndex = 0; colIndex < row.size(); colIndex++ ) {
                setValueAt(row.get(colIndex), rowIndex, colIndex);
            }
        }
        int rowIndex = existingRows.get(subsystem);
        if ( getValueAt(rowIndex, 1).equals("OFF_LINE") ) {
            removeRow(rowIndex);
        }
        
    }
    
    
    private Vector convertStateBundle(String subsystem, StateBundle sb) {
        Map<String,String> allStates = sb.getAllStatesAsStrings();
        Vector row = new Vector();
        row.add(0, subsystem);
        for (String col : defaultStates) {
            String state = col+"State";
            row.add(allStates.remove(state));
        }
        
        for (Entry<String,String> state : allStates.entrySet()) {
            if ( getColumnCount() <= row.size() ) {
                addColumn("");
            }
            row.add(state.getKey().replace("State", "")+": "+state.getValue());
        }
        
        return row;
    }
    
    void clear() {
        for ( int i = 0; i < getRowCount(); i++ ) {
            removeRow(0);
        }
        existingRows.clear();        
    }
    
}
