package org.lsst.ccs.gconsole.plugins.states;

import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.messaging.StatusMessageListener;

/**
 * A State Change Listener for a given subsystem.
 *
 * @author The LSST CCS Team
 */
public class SubsystemStatesChangeListener implements StatusMessageListener {

    private final String subsystem;
    private volatile boolean initialized = false;
    private final SubsystemStatesTableModel model;
    private final Object lock = new Object();

    public SubsystemStatesChangeListener(String subsystem, SubsystemStatesTableModel model) {
        this.subsystem = subsystem;
        this.model = model;
    }

    @Override
    public void onStatusMessage(StatusMessage msg) {
        if (!initialized) {
            synchronized (lock) {
                StateBundle s = msg.getState();
                model.updateRow(subsystem, s);
                initialized = true;
            }
        } else if ( msg instanceof StatusStateChangeNotification ) {
            synchronized (lock) {
                StatusStateChangeNotification sscn = (StatusStateChangeNotification) msg;
                model.updateRow(subsystem, sscn.getNewState());
            }
        }
    }
    
    String getSubsystem() {
        return subsystem;
    }

    void disable() {
    }
}
