package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.Component;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Properties;
import javax.swing.JComponent;
import org.freehep.application.Application;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.mdi.PageEvent;
import org.freehep.application.mdi.PageListener;
import org.freehep.application.mdi.PageManager;
import org.freehep.application.studio.Studio;
import org.freehep.graphicsbase.util.export.ExportDialog;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.lsst.ccs.gconsole.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;

/**
 * Graphical console plugin that supports display of monitoring data.
 *
 * @author onoprien
 */
@Plugin(name="LSST Monitoring Plugin",
        id="monitor",
        description="LSST CCS monitoring data display service.")
public class LsstMonitorPlugin extends ConsolePlugin {

// -- Fields : -----------------------------------------------------------------
    
    static public final String DISPLAY_AS_TREE = "displayAsTree";
    static public final String DISPLAY_DOT_SEPARATOR = "displayDotSeparator";
    
    private final Studio app = (Studio) Application.getApplication();
//    private final AgentStatusAggregator aggregator = new AgentStatusAggregator(true);

// -- Life cycle : -------------------------------------------------------------

    @Override
    public void initialize() {
        
        getServices().addProperty(DISPLAY_AS_TREE, false);
        getServices().addPreference(new String[] {"LSST","Monitor"}, "Data Display", "${"+ DISPLAY_AS_TREE +"}Display channels as a tree.");

        PageManager pm = app.getPageManager();
        pm.addPageListener(new Saver());
        
//        aggregator.initialize(getConsole());
    }

    @Override
    public void shutdown() {
//        aggregator.shutdown();
    }

    
// -- Temporary code for saving monitoring pages : -----------------------------
    
    private class Saver extends CommandProcessor implements PageListener {
        
        private boolean on;

        @Override
        public void pageChanged(PageEvent pe) {
            PageContext context = pe.getPageContext();
            if (context == null) return;
            JComponent panel = (JComponent) context.getPage();
            if (panel == null) return;
            switch (pe.getID()) {
                case PageEvent.PAGESELECTED:
                    MonitorDisplay md = findMonitorDisplay(panel, false);
                    if (md == null) {
                        if (on) {
                            app.getCommandTargetManager().remove(this);
                            on = false;
                        }
                    } else {
                        if (!on) {
                            app.getCommandTargetManager().add(this);
                            on = true;
                        }
                    }
                    break;
                case PageEvent.PAGEDESELECTED:
//                    if (on) {
//                        app.getCommandTargetManager().remove(this);
//                        on = false;
//                    }
                    break;
            }
        }
        
        private MonitorDisplay findMonitorDisplay(JComponent component, boolean visibleOnly) {
            if (visibleOnly && !component.isShowing()) {
                return null;
            }
            if (component instanceof MonitorDisplay) {
                return (MonitorDisplay) component;
            }
            Component[] cc = component.getComponents();
            for (Component c : cc) {
                if (c instanceof JComponent) {
                    MonitorDisplay md = findMonitorDisplay((JComponent)c, visibleOnly);
                    if (md != null) return md;
                }
            }
            return null;
        } 
        
        public void onSaveAs() {
            try {
                PageManager pm = app.getPageManager();
                PageContext context = pm.getSelectedPage();
                JComponent component = (JComponent) context.getPage();
                MonitorDisplay md = findMonitorDisplay(component, true);

                Properties user = app.getUserProperties();
                String creator = "creator";
                ExportDialog dlg = new ExportDialog(creator, false);
                dlg.addExportFileType(new MonitorExport());
                dlg.addExportFileType(new MonitorExport()); // working around the bug in ExportDialog line 160
                dlg.setUserProperties(user);
                dlg.showExportDialog(app, "Save As...", (Component)md, "monitor");
            } catch (NullPointerException|ClassCastException x) {
                app.error("No selected monitoring table", x);
            }
        }
        
    }
    
    static public void saveData(OutputStream out, String mimeType, List<Channel> channels) {
        
        PrintStream ps = new PrintStream(out);
        int n = Field.values().length;
        
        StringBuilder sb = new StringBuilder();
        for (Field field : Field.values()) {
            sb.append(field).append(",");
        }      
        ps.println(sb.substring(0, sb.length()-1));
        
        for (Channel channel : channels) {
            sb = new StringBuilder();
            for (Field field : Field.values()) {
                sb.append(channel.get(field)).append(",");
            }
            ps.println(sb.substring(0, sb.length()-1));
        }
        
    }

}
