package org.lsst.ccs.gconsole.jas3;

import org.freehep.application.Application;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.freehep.util.FreeHEPLookup;
import org.lsst.ccs.Agent;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.utilities.logging.Logger;

/**
 * Optional superclass for LSST CCS plugins that choose to extend {@code org.freehep.application.studio.Plugin}.
 * Provides additional services and convenience  methods.
 * 
 * @deprecated The recommended way to define a graphical console plugin is to extend
 * {@link org.lsst.ccs.gconsole.base.ConsolePlugin ConsolePlugin} and 
 * annotate it as {@link org.lsst.ccs.gconsole.Plugin @Plugin}.
 *
 * @author onoprien
 */
@Deprecated
public class LsstPlugin extends Plugin {

// -- Getters : ----------------------------------------------------------------
    
    /**
     * Access to the {@code AgentMessagingLayer} singleton.
     * 
     * @return {@code AgentMessagingLayer} instance provided by the graphical console.
     * @throws IllegalStateException if the messaging access has not been initialized yet.
     */
    public AgentMessagingLayer getMessagingAccess() {
        Console console = (Console) getLookup().lookup(Console.class);
        if (console == null) throw new IllegalStateException("The agent has not been initialized.");
        return console.getMessagingAccess();
    }
    
    /**
     * Access to the lookup singleton.
     * @return {@code FreeHEPLookup} instance used by the graphical console.
     */
    public FreeHEPLookup getLookup() {
        return ((Studio)(Application.getApplication())).getLookup();
    }
    
    /**
     * Returns the default logger associated with the graphical console.
     * @return Default logger.
     */
    public Logger getLogger() {
        return Logger.getLogger("org.lsst.ccs.ui");
    }

}
