/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.tracer;

import java.awt.Component;
import java.awt.Point;
import java.util.EnumSet;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.freehep.application.mdi.PageEvent;
import org.freehep.application.mdi.PageListener;
import org.freehep.swing.popup.HasPopupItems;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandMessage;
import org.lsst.ccs.bus.messages.LogMessage;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.gconsole.plugins.alert.AlertService;
import org.lsst.ccs.gconsole.plugins.tracer.FilterChooser;
import org.lsst.ccs.gconsole.plugins.tracer.FilterEditor;
import org.lsst.ccs.gconsole.plugins.tracer.FilterRegistry;
import org.lsst.ccs.gconsole.plugins.tracer.FilteredMessage;
import org.lsst.ccs.gconsole.plugins.tracer.LsstTracerPlugin;
import org.lsst.ccs.gconsole.plugins.tracer.MessageFilter;
import org.lsst.ccs.gconsole.plugins.tracer.TracerMessage;
import org.lsst.ccs.gconsole.plugins.tracer.TracerWriter;
import org.lsst.ccs.gconsole.plugins.tracer.UserFilter;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.CommandMessageListener;
import org.lsst.ccs.messaging.LogMessageListener;
import org.lsst.ccs.messaging.StatusMessageListener;

public class Tracer
implements PageListener,
StatusMessageListener,
LogMessageListener,
CommandMessageListener,
HasPopupItems {
    private final LsstTracerPlugin plugin;
    private final AgentMessagingLayer messagingAccess;
    private TracerWriter out;
    private volatile MessageFilter filter;
    private final AlertService alertService;

    Tracer(LsstTracerPlugin plugin) {
        this(plugin, null);
    }

    Tracer(LsstTracerPlugin plugin, MessageFilter filter) {
        this.plugin = plugin;
        this.messagingAccess = plugin.getConsole().getMessagingAccess();
        this.filter = filter;
        this.alertService = (AlertService)plugin.getConsole().getConsoleLookup().lookup(AlertService.class);
    }

    public void setFilter(MessageFilter filter) {
        this.filter = filter;
        if (this.out != null) {
            this.out.reset();
        }
    }

    public void onStatusMessage(StatusMessage msg) {
        this.onBusMessage((BusMessage)msg);
    }

    public void onLogMessage(LogMessage msg) {
        this.onBusMessage((BusMessage)msg);
    }

    public void onCommandMessage(CommandMessage msg) {
        this.onBusMessage((BusMessage)msg);
    }

    private void onBusMessage(BusMessage message) {
        if (this.filter == null) {
            this.out.println(message);
        } else {
            FilteredMessage filteredMessage = new TracerMessage(message);
            if ((filteredMessage = this.filter.test(filteredMessage)) != null) {
                this.out.println(filteredMessage);
                EnumSet<FilteredMessage.Flag> flags = filteredMessage.getFlags();
                if (flags != null) {
                    for (FilteredMessage.Flag flag : flags) {
                        AlertState level = null;
                        switch (flag) {
                            case ATTENTION: {
                                this.plugin.getConsole().getWindow().getToolkit().beep();
                                break;
                            }
                            case LOCAL_CLEAR: {
                                level = AlertState.NOMINAL;
                            }
                            case LOCAL_WARNING: {
                                if (level == null) {
                                    level = AlertState.WARNING;
                                }
                            }
                            case LOCAL_ALARM: {
                                if (level == null) {
                                    level = AlertState.ALARM;
                                }
                                String id = this.filter.getName() == null ? "Unnamed" : this.filter.getName();
                                String description = filteredMessage.getMessage() == null ? filteredMessage.toString() : filteredMessage.getMessage();
                                this.alertService.submitAlert("Tracer", new Alert(id, description), level, description);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void pageChanged(PageEvent pe) {
        if (pe.getID() == 4001) {
            this.messagingAccess.removeStatusMessageListener((StatusMessageListener)this);
            this.messagingAccess.removeCommandMessageListener((CommandMessageListener)this);
            this.messagingAccess.removeLogMessageListener((LogMessageListener)this);
        }
    }

    void start(TracerWriter out) {
        this.out = out;
        this.messagingAccess.addStatusMessageListener((StatusMessageListener)this);
        this.messagingAccess.addCommandMessageListener((CommandMessageListener)this);
        this.messagingAccess.addLogMessageListener((LogMessageListener)this);
    }

    public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component source, Point p) {
        JMenu filterMenu = new JMenu("Filter...");
        JMenuItem item = new JMenuItem("New...");
        item.setToolTipText("Define new filter");
        item.addActionListener(e -> {
            UserFilter f = FilterEditor.showDialog(source, null, this.plugin, this);
        });
        filterMenu.add(item);
        item = new JMenuItem("Load...");
        item.setToolTipText("Load named filter.");
        item.addActionListener(e -> {
            FilterRegistry registry = this.plugin.getFilterRegistry();
            String name = FilterChooser.showDialog(source, registry);
            if (name != null) {
                try {
                    MessageFilter f = registry.getFilter(name);
                    if (f == null) {
                        this.plugin.getConsole().error("Unknown message filter: " + name);
                    } else {
                        this.setFilter(f);
                    }
                }
                catch (IllegalArgumentException x) {
                    this.plugin.getConsole().error("Error initializing message filter " + name, x);
                }
            }
        });
        filterMenu.add(item);
        item = new JMenuItem("Edit...");
        item.setToolTipText("Edit filter");
        item.addActionListener(e -> {
            UserFilter f = FilterEditor.showDialog(source, this.filter, this.plugin, this);
        });
        filterMenu.add(item);
        item = new JMenuItem("Remove");
        item.setToolTipText("Remove filter");
        item.setEnabled(this.filter != null);
        item.addActionListener(e -> this.setFilter(null));
        filterMenu.add(item);
        menu.insert(filterMenu, 0);
        return menu;
    }
}

