/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.states;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import org.lsst.ccs.bus.states.StateBundle;

public class SubsystemStatesTableModel
extends DefaultTableModel {
    private final Map<String, Integer> existingRows = new HashMap<String, Integer>();
    private static final String[] defaultStates = new String[]{"Phase", "Command", "Operational", "Alert", "Configuration"};

    public SubsystemStatesTableModel() {
        this.addColumn("Agent");
        for (String col : defaultStates) {
            this.addColumn(col);
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    synchronized void updateRow(String subsystem, StateBundle sb) {
        int rowIndex;
        Vector row = this.convertStateBundle(subsystem, sb);
        if (!this.existingRows.containsKey(subsystem)) {
            this.addRow(row);
            this.existingRows.put(subsystem, this.getRowCount() - 1);
        } else {
            rowIndex = this.existingRows.get(subsystem);
            for (int colIndex = 0; colIndex < row.size(); ++colIndex) {
                this.setValueAt(row.get(colIndex), rowIndex, colIndex);
            }
        }
        rowIndex = this.existingRows.get(subsystem);
        if (this.getValueAt(rowIndex, 1).equals("OFF_LINE")) {
            this.removeRow(rowIndex);
        }
    }

    private Vector convertStateBundle(String subsystem, StateBundle sb) {
        Map allStates = sb.getAllStatesAsStrings();
        Vector<String> row = new Vector<String>();
        row.add(0, subsystem);
        for (String col : defaultStates) {
            String state = col + "State";
            row.add((String)allStates.remove(state));
        }
        for (Map.Entry entry : allStates.entrySet()) {
            if (this.getColumnCount() <= row.size()) {
                this.addColumn("");
            }
            row.add(((String)entry.getKey()).replace("State", "") + ": " + (String)entry.getValue());
        }
        return row;
    }

    void clear() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.removeRow(0);
        }
        this.existingRows.clear();
    }
}

