/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.states;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.plugins.states.SubsystemStatesChangeListener;
import org.lsst.ccs.gconsole.plugins.states.SubsystemStatesTable;
import org.lsst.ccs.gconsole.plugins.states.SubsystemStatesTableModel;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.StatusMessageListener;

@Plugin(name="LSST States Plugin", id="state", description="LSST CCS subsystem states service.")
public class LsstStatesPlugin
extends ConsolePlugin
implements AgentPresenceListener {
    private final SubsystemStatesTableModel model = new SubsystemStatesTableModel();
    private final List<SubsystemStatesChangeListener> listeners = new ArrayList<SubsystemStatesChangeListener>();
    private final JComponent statesPage = new JScrollPane(new SubsystemStatesTable(this.model));
    private final Action statesAction = new AbstractAction("States"){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (((Boolean)this.getValue("SwingSelectedKey")).booleanValue()) {
                LsstStatesPlugin.this.openStatesPage();
            } else {
                LsstStatesPlugin.this.closeStatesPage();
            }
        }
    };

    public LsstStatesPlugin() {
        this.statesAction.putValue("SwingSelectedKey", false);
    }

    @Override
    public synchronized void initialize() {
        this.getServices().addMenu(this.statesAction, "400: CCS Tools :-1:15");
    }

    private synchronized void openStatesPage() {
        this.statesAction.putValue("SwingSelectedKey", true);
        this.getConsole().getPanelManager().open((Component)this.statesPage, "Subsystem States");
        this.getConsole().getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
    }

    private synchronized void closeStatesPage() {
        this.statesAction.putValue("SwingSelectedKey", false);
        this.getConsole().getPanelManager().close(this.statesPage);
        this.getConsole().getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener((AgentPresenceListener)this);
        for (SubsystemStatesChangeListener listener : this.listeners) {
            this.getConsole().getMessagingAccess().removeStatusMessageListener((StatusMessageListener)listener);
        }
        this.listeners.clear();
        this.model.clear();
    }

    public void connecting(AgentInfo agent) {
        SubsystemStatesChangeListener listener = new SubsystemStatesChangeListener(agent.getName(), this.model);
        this.listeners.add(listener);
        this.getConsole().getMessagingAccess().addStatusMessageListener((StatusMessageListener)listener, BusMessageFilterFactory.messageOrigin((String)agent.getName()));
    }

    public void disconnecting(AgentInfo agent) {
        for (SubsystemStatesChangeListener listener : this.listeners) {
            if (!listener.getSubsystem().equals(agent.getName())) continue;
            this.getConsole().getMessagingAccess().removeStatusMessageListener((StatusMessageListener)listener);
            listener.disable();
        }
    }
}

