package org.lsst.ccs.gconsole.jas3;

import java.awt.HeadlessException;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.freehep.jas.JAS3;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

/**
 * Application launcher.
 * 
 * @version $Id: $
 * @author onoprien
 */
public class ConsoleApplication extends JAS3 {

// -- Life cycle : -------------------------------------------------------------
    
    public ConsoleApplication() {
        super("CCS_Console");
    }

    public static void main(final String[] args) {

    // JOptionPane.showMessageDialog(null, "CCS_Console main "); // uncomment to enable debugger attachement

        try {
            new ConsoleApplication().createFrame(args).setVisible(true);
        } catch (HeadlessException x) {
            System.out.println("Fatal Error: " + x.getMessage());
        } catch (Throwable t) {
            System.out.println("Fatal Error: " + t.getMessage());
            error(null, "Fatal Error", t);
            System.exit(1);
        }

    }
    
    
// -- Handling properties : ----------------------------------------------------
    
    /**
     * Adds properties from application definition files.
     * 
     * @return Modified application properties.
     * @throws org.freehep.application.Application.InitializationException 
     */
    @Override
    protected Properties createAppProperties() throws InitializationException {
        Properties appProp = super.createAppProperties();
        Properties ccsProp = BootstrapResourceUtils.getBootstrapProperties("gui.properties");
        String appName = ccsProp.getProperty("org.lsst.ccs.application.name");
        String prefName = ccsProp.getProperty("org.lsst.ccs.gui.preferences", appName);
        if (prefName != null) {
            if (!prefName.endsWith(".properties")) prefName = prefName + ".properties";
            appProp.setProperty("userPrefDir", appProp.getProperty("org.lsst.ccs.gui.home") +"/"+ prefName);
        }
        ccsProp.stringPropertyNames().forEach(key -> appProp.setProperty(key, ccsProp.getProperty(key)));
        return appProp;
    }

}
