/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataOutput;
import java.util.Arrays;
import org.jgroups.util.Buffer;

public class ByteArrayDataOutputStream
implements DataOutput {
    protected byte[] buf;
    protected int pos;

    public ByteArrayDataOutputStream() {
        this(32);
    }

    public ByteArrayDataOutputStream(int capacity) {
        this.buf = new byte[capacity];
    }

    public ByteArrayDataOutputStream position(int pos) {
        this.pos = this.checkBounds(pos);
        return this;
    }

    public int position() {
        return this.pos;
    }

    public byte[] buffer() {
        return this.buf;
    }

    public Buffer getBuffer() {
        return new Buffer(this.buf, 0, this.pos);
    }

    @Override
    public void write(int b) {
        this.ensureCapacity(1);
        this.buf[this.pos++] = (byte)b;
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len - b.length > 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(len);
        System.arraycopy(b, off, this.buf, this.pos, len);
        this.pos += len;
    }

    @Override
    public void writeBoolean(boolean v) {
        this.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) {
        this.write(v);
    }

    @Override
    public void writeShort(int v) {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    @Override
    public void writeChar(int v) {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    @Override
    public void writeInt(int v) {
        this.write(v >>> 24 & 0xFF);
        this.write(v >>> 16 & 0xFF);
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    @Override
    public void writeLong(long v) {
        this.write((byte)(v >>> 56));
        this.write((byte)(v >>> 48));
        this.write((byte)(v >>> 40));
        this.write((byte)(v >>> 32));
        this.write((byte)(v >>> 24));
        this.write((byte)(v >>> 16));
        this.write((byte)(v >>> 8));
        this.write((byte)(v >>> 0));
    }

    @Override
    public void writeFloat(float v) {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeBytes(String s) {
        int len;
        int n = len = s != null ? s.length() : 0;
        if (len > 0) {
            this.ensureCapacity(len);
        }
        for (int i = 0; i < len; ++i) {
            this.write((byte)s.charAt(i));
        }
    }

    @Override
    public void writeChars(String s) {
        int len;
        int n = len = s != null ? s.length() : 0;
        if (len > 0) {
            this.ensureCapacity(len * 2);
        }
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this.writeChar(v);
        }
    }

    @Override
    public void writeUTF(String str) {
        char c;
        int strlen;
        int n = strlen = str != null ? str.length() : 0;
        if (strlen > 0) {
            this.ensureCapacity(strlen * 2 + 2);
        }
        int utflen = 0;
        int count = 0;
        if (str == null) {
            this.writeShort(-1);
            return;
        }
        for (int i = 0; i < strlen; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new IllegalArgumentException("encoded string too long: " + utflen + " bytes");
        }
        byte[] bytearr = new byte[utflen + 2];
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen >>> 0 & 0xFF);
        int i = 0;
        for (i = 0; i < strlen && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            bytearr[count++] = (byte)c;
        }
        while (i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
        this.write(bytearr, 0, utflen + 2);
    }

    public String toString() {
        return "pos=" + this.pos + " lim=" + this.buf.length;
    }

    protected int checkBounds(int pos) {
        if (pos < 0 || pos > this.buf.length) {
            throw new IndexOutOfBoundsException("pos=" + pos + ", length=" + this.buf.length);
        }
        return pos;
    }

    protected void ensureCapacity(int bytes) {
        if (this.pos + bytes > this.buf.length) {
            int new_size = this.buf.length + bytes + 32;
            this.buf = Arrays.copyOf(this.buf, new_size);
        }
    }
}

