package org.lsst.ccs.gconsole.plugins.monitor;

import java.util.*;
import javax.swing.JComponent;

/**
 * GUI components that display monitoring data can implement this interface to get updated.
 *
 * @author onoprien
 */
public interface MonitorView {
    
    void setName(String name);
    
    String getName();
   
    void setChannels(LinkedHashMap<String,Channel> channels);

    void addChannel(String path, Channel channel);

    void removeChannel(String path);

    void update(String path, Channel channel);
    
    void update(String path);
    
    void update(String path, Field field);
    
    void update(String path, EnumSet<Field> fields);
    
    JComponent getView();

//    void update(String path, Field field, Object value);
//
//    void updateValue(String path, double value);
//    
//    void addListener(Listener listener);
//    
//    void removeListener(Listener listener);
//    
//    
//    public static interface Listener {
//        
//    }
    
}
