package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.swing.JComponent;
import org.freehep.graphicsbase.util.export.ExportFileType;

/**
 * {@link ExportFileType} for saving monitoring pages.
 *
 * @author onoprien
 */
public class MonitorExport extends ExportFileType {

    @Override
    public String getDescription() {
        return "Comma Separated Values";
    }

    @Override
    public String[] getExtensions() {
        return new String[] {"csv"};
    }

    @Override
    public String[] getMIMETypes() {
        return new String[] {"text/csv"};
    }

    @Override
    public void exportToFile(OutputStream out, Component[] targets, Component parent, Properties prop, String creator) throws IOException {
        for (Component c : targets) {
            if (c instanceof MonitorDisplay) {
                MonitorDisplay md = (MonitorDisplay) c;
                md.saveData(out, getMIMETypes()[0]);
            }
        }
    }

    @Override
    public void exportToFile(File file, Component[] targets, Component parent, Properties prop, String creator) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file)) {
            exportToFile(out, targets, parent, prop, creator);
        }
    }

}
