package org.lsst.ccs.gconsole.plugins.monitor;

import org.lsst.ccs.subsystem.monitor.data.MonitorChan;

/**
 * Data describing parameters and current state of a monitored channel.
 *
 * @author onoprien
 */
public class Channel extends MonitorChan {
    
// -- Fields : -----------------------------------------------------------------
    
    private boolean good;
    private boolean online;
    private boolean highLimitChanged;
    private boolean lowLimitChanged;
    private final String path;


// -- Life cycle : -------------------------------------------------------------
    
    public Channel(String subsystemName, MonitorChan mc) {
        super(mc.getName(), mc.getDescription(), mc.getFormat(), mc.getUnits(), mc.getPage(),
                       mc.getLowLimit(), mc.getLowWarning(), mc.getLowAlarm(),
                       mc.getHighLimit(), mc.getHighWarning(), mc.getHighAlarm(),
                       mc.getValue());
        path = subsystemName +"/"+ mc.getName();
    }
    
    
// -- Getters and setters : ----------------------------------------------------
    
    public Object get(Field field) {
        switch (field) {
            case NAME:
                return getName();
            case VALUE:
                return getValue();
            case UNITS:
                return getUnits();
            case LOW:
                return getLowLimit();
            case ALERT_LOW:
                return getLowAlarm();
            case HIGH:
                return getHighLimit();
            case ALERT_HIGH:
                return getHighAlarm();
            case DESCR:
                return getDescription();
            default:
                return null;
        }
    }
    
    public void set(Field field, Object value) {
        switch (field) {
            case VALUE:
                setValue((Double)value); break;
            case UNITS:
                setUnits((String)value); break;
            case LOW:
                setLowLimit((Double)value); break;
            case ALERT_LOW:
                setLowAlarm((String)value); break;
            case HIGH:
                setHighLimit((Double)value); break;
            case ALERT_HIGH:
                setHighAlarm((String)value); break;
            case NAME:
                setName((String)value); break;
            default:
                throw new IllegalArgumentException("Field "+ field +" cannot be modified.");
        }
    }

    public boolean isGood() {
        return good;
    }

    public void setGood(boolean good) {
        this.good = good;
    }

    public boolean isOnline() {
        return online;
    }

    public void setOnline(boolean online) {
        this.online = online;
    }

    public boolean isHighLimitChanged() {
        return highLimitChanged;
    }

    public void setHighLimitChanged(boolean highLimitChanged) {
        this.highLimitChanged = highLimitChanged;
    }

    public boolean isLowLimitChanged() {
        return lowLimitChanged;
    }

    public void setLowLimitChanged(boolean lowLimitChanged) {
        this.lowLimitChanged = lowLimitChanged;
    }

    public String getPath() {
        return path;
    }
    
    public String getSubsystemName() {
        return path.substring(0, path.indexOf("/"));
    }
    
}
