/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.description;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.utilities.logging.Logger;

public class ComponentNode<T extends ComponentNode<T>>
implements Serializable {
    private static final long serialVersionUID = 284121597899337112L;
    protected static final Logger logger = Logger.getLogger((String)"org.lsst.ccs.description");
    private String key;
    private ComponentNode<T> parent;
    private final List<T> children = new ArrayList<T>();
    private Object component;
    private String protocol;

    public ComponentNode(T parent, String name) {
        this(parent, name, null);
    }

    public ComponentNode(T parent, String name, Object component) {
        this.parent = parent;
        this.key = name;
        this.component = component;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public Object getComponent() {
        return this.component;
    }

    public void setComponent(Object component) {
        if (this.component != null) {
            throw new RuntimeException("Cannot set component twice.");
        }
        this.component = component;
        for (ComponentNode child : this.children) {
            String childKey = child.getKey();
            Field parentField = null;
            Class<?> cls = component.getClass();
            while (cls.getCanonicalName().startsWith("org.lsst")) {
                try {
                    parentField = cls.getDeclaredField(childKey);
                    break;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    cls = cls.getSuperclass();
                }
            }
            if (parentField == null) {
                return;
            }
            try {
                Object childComp = child.getComponent();
                if (parentField.getType().isAssignableFrom(childComp.getClass())) {
                    parentField.setAccessible(true);
                    parentField.set(component, childComp);
                    logger.warn((Object)("field " + parentField.getName() + " of component " + this.getKey() + " has been automatically set to " + childKey));
                    logger.warn((Object)"This feature is to be discontinued and should be replaced with @LookupField annotation");
                    continue;
                }
                logger.warn((Object)("could not set field " + childKey + " of " + this.getKey() + " : classes don't match"));
            }
            catch (IllegalAccessException ex) {
                logger.warn((Object)("could not set field " + childKey + " of " + this.getKey()), (Throwable)ex);
            }
        }
    }

    void setParent(ComponentNode<T> parent) {
        this.parent = parent;
    }

    public String getKey() {
        return this.key;
    }

    public List<T> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void addChild(T child) throws NullPointerException {
        ((ComponentNode)child).setParent(this);
        this.children.add(child);
    }

    public String toString() {
        String valueString;
        try {
            valueString = String.valueOf(this.component);
        }
        catch (Exception exc) {
            valueString = "can't trace value [" + exc + "] ";
        }
        return String.valueOf(String.valueOf(this.key)) + "(" + valueString + ") {" + String.valueOf(this.children) + "}";
    }

    public ComponentNode<T> getParent() {
        return this.parent;
    }
}

