/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Immutable;
import org.lsst.ccs.localdb.configdb.model.AParameterDescription;
import org.lsst.ccs.localdb.configdb.model.ImmutableStateException;
import org.lsst.ccs.localdb.configdb.model.ParameterDescription;
import org.lsst.ccs.localdb.configdb.model.ParameterPath;
import org.lsst.ccs.localdb.configdb.model.SubsystemDescription;

@Table(uniqueConstraints={@UniqueConstraint(columnNames={"subsystemName", "tag"})})
@Entity
@Immutable
public class ASubsystemDescription
extends SubsystemDescription
implements Cloneable {
    private static final long serialVersionUID = 7518445583831244327L;
    @Id
    @GeneratedValue
    private long id;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    protected Map<ParameterPath, AParameterDescription> paramDescriptions = new HashMap<ParameterPath, AParameterDescription>();
    @Transient
    private Set<String> categorySet = new HashSet<String>();

    protected ASubsystemDescription() {
    }

    public ASubsystemDescription(String subsystemName, String tag, Serializable configurationData) {
        super(subsystemName, tag, configurationData);
    }

    public ASubsystemDescription(SubsystemDescription other) {
        super(other);
        for (ParameterDescription parameterDescription : other.getParamDescriptionMap().values()) {
            this.addParameterDescriptions(new AParameterDescription(parameterDescription));
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    void setId(long id) {
        this.id = id;
    }

    @Override
    public Map<ParameterPath, ? extends ParameterDescription> getParamDescriptionMap() {
        return this.paramDescriptions;
    }

    @Override
    public Set<String> getCategorySet() {
        return Collections.unmodifiableSet(this.categorySet);
    }

    @Override
    public long getStartTimestamp() {
        return super.getStartTimestamp();
    }

    Collection<AParameterDescription> getParamDescriptions() {
        return this.paramDescriptions.values();
    }

    void setParamDescriptions(Map<ParameterPath, AParameterDescription> paramDescriptions) {
        this.paramDescriptions = paramDescriptions;
    }

    public ASubsystemDescription clone() {
        ASubsystemDescription res = null;
        try {
            res = (ASubsystemDescription)super.clone();
            HashMap<ParameterPath, AParameterDescription> newMap = new HashMap<ParameterPath, AParameterDescription>();
            for (AParameterDescription description : this.paramDescriptions.values()) {
                newMap.put(description.getPath(), description.clone());
            }
            res.setParamDescriptions(newMap);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return res;
    }

    @Override
    public void addParameterDescriptions(ParameterDescription ... descriptions) {
        this.addParameterDescriptions(this.buildSafeArray(descriptions));
    }

    @Override
    public void addParameterDescriptions(Collection<ParameterDescription> descriptions) {
        for (ParameterDescription parm : descriptions) {
            if (!(parm instanceof AParameterDescription)) {
                this.addParameterDescriptions(new AParameterDescription(parm));
                continue;
            }
            this.addParameterDescriptions((AParameterDescription)parm);
        }
    }

    private AParameterDescription[] buildSafeArray(ParameterDescription ... descriptions) {
        List<ParameterDescription> list = Arrays.asList(descriptions);
        AParameterDescription[] parms = new AParameterDescription[descriptions.length];
        int ix = 0;
        for (ParameterDescription description : list) {
            parms[ix] = !(description instanceof AParameterDescription) ? new AParameterDescription(description) : (AParameterDescription)description;
            ++ix;
        }
        return parms;
    }

    public void addParameterDescriptions(AParameterDescription ... descriptions) {
        if (this.isReadOnly()) {
            throw new ImmutableStateException("parameter description list");
        }
        for (AParameterDescription description : descriptions) {
            this.paramDescriptions.put(description.getPath(), description);
            this.categorySet.add(description.getCategory());
        }
    }

    @Override
    public void removeParameterDescriptions(ParameterDescription ... descriptions) {
        if (this.isReadOnly()) {
            throw new ImmutableStateException("parameter description list");
        }
        for (ParameterDescription description : descriptions) {
            this.paramDescriptions.remove(description);
        }
    }
}

