/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.monitor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ComponentConfigurationEnvironment;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasAgentPeriodicTasks;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.CalcDevice;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Control;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.Line;
import org.lsst.ccs.monitor.Page;
import org.lsst.ccs.subsystem.monitor.data.MonitorChan;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;
import org.lsst.ccs.subsystem.monitor.data.MonitorState;
import org.lsst.ccs.utilities.logging.Logger;

public class Monitor
implements HasLifecycle,
HasAgentPeriodicTasks {
    private static final int DEFAULT_UPDATE_PERIOD = 1000;
    private static final int DEFAULT_CHECK_PERIOD = 10000;
    static final String CALC_DEVICE_NAME = "Calc";
    static final String LIMITS = "Limits";
    private Module module;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, Device> devcMap = new HashMap<String, Device>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, Channel> chanMap = new LinkedHashMap<String, Channel>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, Alarm> alarmMap = new HashMap<String, Alarm>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, Line> lineMap = new HashMap<String, Line>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, Page> pageMap = new HashMap<String, Page>();
    private final BitSet goodChans = new BitSet();
    private final BitSet onlineChans = new BitSet();
    private final CalcDevice calcDevc = new CalcDevice();
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected AlarmHandler alarmH;
    protected Logger log;
    @LookupField(strategy=LookupField.Strategy.TOP)
    Subsystem subsys;
    final BitSet loLimChange = new BitSet();
    final BitSet hiLimChange = new BitSet();
    private int numChans;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Channel[] chanData;
    private boolean doPublishData;

    public Monitor(Subsystem a) {
        this(a, null);
    }

    protected Monitor() {
    }

    protected Monitor(Agent a, AlarmHandler alarmHand) {
        if (!(a instanceof Subsystem)) {
            throw new RuntimeException("Monitor cannot be created for an Agent");
        }
    }

    @Override
    public void init() {
        this.log = this.subsys.getLogger();
        this.module = (Module)this.subsys.getComponentLookup().getComponentByName("main");
        this.log.finest((Object)"Initializing monitor framework");
        this.initConfiguration();
    }

    @Deprecated
    public void initConfiguration() {
        this.devcMap.put(CALC_DEVICE_NAME, this.calcDevc);
        for (Device devc : this.devcMap.values()) {
            devc.configure(this);
        }
        for (Line line : this.lineMap.values()) {
            line.configure(this);
        }
        for (Alarm alarm : this.alarmMap.values()) {
            alarm.configure();
        }
        for (int i = 0; i < this.chanData.length; ++i) {
            this.chanData[i].configure(this, i);
        }
    }

    @Deprecated
    public void initSensors() {
        this.initSensors(10000);
    }

    @Deprecated
    public void initSensors(int checkPeriod) {
        System.out.println("DEPRECATED: Monitor method initSensors has been deprecated and it no longer has any effect.\nAny calls to this method can be safely removed as its functionality has been incorporated in the Subsystem class.");
    }

    public void readSensors() {
        for (Device devc : this.devcMap.values()) {
            devc.readSensors();
        }
    }

    @Deprecated
    public void start(int period) {
        System.out.println("DEPRECATED: Monitor method start has been deprecated and it no longer has any effect.\nAny calls to this method can be safely removed as its functionality has been incorporated in the Subsystem class.");
    }

    @Override
    public void postStart() throws HardwareException {
        this.publishMonitorState();
        this.publishMonitorLimits();
    }

    @Override
    public List<AgentPeriodicTask> getAgentPeriodicTasks() {
        ArrayList<AgentPeriodicTask> res = new ArrayList<AgentPeriodicTask>();
        res.add(new AgentPeriodicTask(() -> {
            this.readSensors();
            this.updateState();
        }, true, "UpdateState", Level.SEVERE, 1000L, TimeUnit.MILLISECONDS));
        res.add(new AgentPeriodicTask(() -> {
            for (String devName : this.getDeviceNames()) {
                this.getDevice(devName).checkOnline();
            }
        }, true, "CheckDevices", Level.SEVERE, 10000L, TimeUnit.MILLISECONDS));
        res.add(new AgentPeriodicTask(() -> this.doPublishData(), true, "PublishData", Level.SEVERE, 1000L, TimeUnit.MILLISECONDS));
        return res;
    }

    public MonitorFullState getFullState() {
        return this.getMonitorFullState();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the full monitoring state")
    public MonitorFullState getMonitorFullState() {
        MonitorFullState state = new MonitorFullState();
        for (Alarm alarm : this.alarmMap.values()) {
            state.addAlarm(alarm.getName(), alarm.getDescription());
        }
        for (Page page : this.pageMap.values()) {
            state.addPage(Integer.valueOf(page.getId()), page.getLabel());
        }
        for (Iterator<Object> iterator : this.chanData) {
            state.addChannel(new MonitorChan(((Channel)((Object)iterator)).getName(), ((Channel)((Object)iterator)).getDescription(), ((Channel)((Object)iterator)).getFormat(), ((Channel)((Object)iterator)).getUnits(), ((Channel)((Object)iterator)).getPageId(), ((Channel)((Object)iterator)).getLimitLo(), 0.0, ((Channel)((Object)iterator)).getAlarmNameLo(), ((Channel)((Object)iterator)).getLimitHi(), 0.0, ((Channel)((Object)iterator)).getAlarmNameHi(), ((Channel)((Object)iterator)).getValue()));
        }
        state.setMonitorState(new MonitorState(this.goodChans, this.onlineChans, this.loLimChange, this.hiLimChange));
        return state;
    }

    @Deprecated
    public void publishState() {
        this.publishMonitorState();
    }

    void publishMonitorState() {
        MonitorState state = new MonitorState(this.goodChans, this.onlineChans, this.loLimChange, this.hiLimChange);
        KeyValueData data = new KeyValueData("MonitorState", (Serializable)state);
        this.subsys.publishSubsystemDataOnStatusBus(data);
    }

    @Deprecated
    public void publishData() {
        System.out.println("Calls to method publishData can be safely removed, as the Monitor framework now provides a periodic task to publish monitored quantities.");
    }

    private void doPublishData() {
        KeyValueDataList dataList = new KeyValueDataList();
        for (Channel ch : this.chanData) {
            if (ch.getState() == -1) continue;
            dataList.addData(ch.getName(), (Serializable)Double.valueOf(ch.getValue()), ch.getTimestamp());
        }
        if (!dataList.getListOfKeyValueData().isEmpty()) {
            this.subsys.publishSubsystemDataOnStatusBus((KeyValueData)dataList);
        }
    }

    @Deprecated
    public void publishLimits() {
    }

    private void publishMonitorLimits() {
        for (Channel ch : this.chanData) {
            KeyValueDataList data = new KeyValueDataList(ch.getName());
            data.addData("alarmLow", (Serializable)((Object)String.valueOf(ch.getLimitLo())), KeyValueData.KeyValueDataType.KeyValueMetaData);
            data.addData("alarmHigh", (Serializable)((Object)String.valueOf(ch.getLimitHi())), KeyValueData.KeyValueDataType.KeyValueMetaData);
            this.subsys.publishSubsystemDataOnStatusBus((KeyValueData)data);
        }
    }

    public void updateState() {
        BitSet goodState = new BitSet(this.numChans);
        BitSet onlineState = new BitSet(this.numChans);
        for (Channel ch : this.chanData) {
            ch.checkLimits(goodState);
            ch.checkOnline(onlineState);
        }
        for (Alarm alarm : this.alarmMap.values()) {
            alarm.setState();
        }
        goodState.xor(this.goodChans);
        this.goodChans.xor(goodState);
        onlineState.xor(this.onlineChans);
        this.onlineChans.xor(onlineState);
        if (!goodState.isEmpty() || !onlineState.isEmpty()) {
            this.publishMonitorState();
        }
        if (!goodState.isEmpty() || this.doPublishData) {
            this.doPublishData();
            this.doPublishData = false;
        }
    }

    @Deprecated
    public void checkLimits() {
        this.updateState();
    }

    public void setPublishData() {
        this.doPublishData = true;
    }

    public void clearLimitChanges() {
        this.loLimChange.clear();
        this.hiLimChange.clear();
    }

    public Device getDevice(String name) {
        return this.devcMap.get(name);
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of all devices")
    public List<String> getDeviceNames() {
        return new ArrayList<String>(this.devcMap.keySet());
    }

    @Deprecated
    @Command(type=Command.CommandType.QUERY, description="Get the map of all configured values")
    public Map<String, Object> getConfigurationMap() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        ComponentConfigurationEnvironment cce = null;
        for (Device devc : this.devcMap.values()) {
            cce = this.subsys.getComponentConfigurationEnvironment(devc);
            values.putAll(cce.printConfigurableParameters(null));
            for (Control ctl : devc.ctlChans.values()) {
                cce = this.subsys.getComponentConfigurationEnvironment(ctl);
                values.putAll(cce.printConfigurableParameters(null));
            }
        }
        return values;
    }

    public Line getLine(String name) {
        return this.lineMap.get(name);
    }

    public Alarm getAlarm(String name) {
        return this.alarmMap.get(name);
    }

    public Channel getChannel(String name) {
        return this.chanMap.get(name);
    }

    public Channel getChannel(int id) {
        return this.chanData[id];
    }

    public int getChannelId(String name) {
        Channel chan = this.chanMap.get(name);
        return chan == null ? -1 : chan.getId();
    }

    public void setOnline(BitSet mask, boolean online) {
        BitSet prevOnline = (BitSet)this.onlineChans.clone();
        if (online) {
            this.onlineChans.or(mask);
        } else {
            this.onlineChans.andNot(mask);
        }
        if (!this.onlineChans.equals(prevOnline)) {
            this.publishMonitorState();
        }
    }

    public int getNumChans() {
        return this.numChans;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of channel names")
    public List<String> getChannelNames() {
        return new ArrayList<String>(this.chanMap.keySet());
    }

    @Command(type=Command.CommandType.QUERY, description="Get a channel value")
    public Double getChannelValue(String name) {
        Channel chan = this.chanMap.get(name);
        return chan == null ? null : Double.valueOf(chan.getValue());
    }

    @Command(type=Command.CommandType.QUERY, description="Read a channel value")
    public Double readChannelValue(String name) {
        Channel chan = this.chanMap.get(name);
        return chan == null ? null : Double.valueOf(chan.readValue());
    }

    @Deprecated
    public Module getModule() {
        return this.module;
    }

    @Command(type=Command.CommandType.ACTION, description="Save the monitoring limits")
    public void saveLimits() {
        this.module.getEnvironment().saveChangesForCategories(LIMITS);
        this.clearLimitChanges();
        this.publishMonitorState();
    }

    public AlarmHandler getAlarmHandler() {
        return this.alarmH;
    }

    public static interface AlarmHandler {
        public void processAlarm(int var1, int var2);
    }
}

