/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.states.AgentState;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.config.BulkSettingException;
import org.lsst.ccs.config.ConfigUtils;
import org.lsst.ccs.config.ConfigurationHandlerSet;
import org.lsst.ccs.config.ConfigurationHandlerSetBuilder;
import org.lsst.ccs.config.ConfigurationServiceException;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.utilities.logging.Logger;

public final class SubsystemConfigurationEnvironment {
    private final Subsystem subsystem;
    final ConfigurationHandlerSet configurationHandler;
    private final Set<String> categories;
    private static final Logger conf_sub_log = Logger.getLogger((String)"org.lsst.ccs.config");
    private static final Alert CS_ALERT_1 = new Alert("CCSCFGSRV", "configuration service unavailable");
    private static final Alert CS_ALERT_2 = new Alert("CCSCFGOP", "operator error");
    private final Object configLock = new Object();

    static SubsystemConfigurationEnvironment create(Subsystem s, ConfigurationHandlerSetBuilder chsb) {
        chsb.initialize(s.getDescription());
        s.addClearAlertHandler(alert -> {
            if (CS_ALERT_1.getAlertId().equals(alert.getAlertId())) {
                return chsb.getConfigurationProxy().isAvailable() ? ClearAlertHandler.ClearAlertCode.CLEAR_ALERT : ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
            }
            if (CS_ALERT_2.getAlertId().equals(alert.getAlertId())) {
                return s.isInState((Enum)ConfigurationState.CONFIGURED) ? ClearAlertHandler.ClearAlertCode.CLEAR_ALERT : ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
            }
            return ClearAlertHandler.ClearAlertCode.UNKWNOWN_ALERT;
        });
        ConfigurationHandlerSet chs = chsb.get();
        if (chs == null) {
            return null;
        }
        return new SubsystemConfigurationEnvironment(s, chs);
    }

    Set<String> getComponents() {
        return this.configurationHandler.getComponents();
    }

    private SubsystemConfigurationEnvironment(Subsystem s, ConfigurationHandlerSet chs) {
        this.subsystem = s;
        this.categories = chs.getCategorySet();
        this.configurationHandler = chs;
    }

    @Command(description="Saves all changes in the current configurations", type=Command.CommandType.CONFIGURATION)
    public final void saveAllChanges() {
        this.saveChangesForCategoriesAsInternal(this.configurationHandler.getTaggedCategoriesForCats(this.categories));
    }

    @Command(description="Saves the specified categories with a name", type=Command.CommandType.CONFIGURATION)
    public final void saveChangesForCategories(String ... categories) {
        this.saveChangesForCategoriesAsInternal(this.configurationHandler.getTaggedCategoriesForCats(ConfigUtils.parseCategories(this.categories, (String[])categories)));
    }

    @Command(description="Saves the specified categories with a name", type=Command.CommandType.CONFIGURATION)
    public final void saveChangesForCategoriesAs(String ... taggedCategories) {
        this.saveChangesForCategoriesAsInternal(ConfigUtils.parseConfigurationString(this.categories, (String[])taggedCategories));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveChangesForCategoriesAsInternal(Map<String, String> taggedCategories) {
        Object object = this.configLock;
        synchronized (object) {
            this.checkValidStates(true, true);
            if (taggedCategories.isEmpty()) {
                return;
            }
            try {
                this.configurationHandler.saveChangesForCategories(taggedCategories);
                ConfigurationInfo ci = this.configurationHandler.getConfigurationInfo();
                this.updateStateAndSendStatusConfigurationInfo(ci);
            }
            catch (RuntimeException ex) {
                this.handleException(ex);
            }
        }
    }

    @Command(description="drop all unsaved changes", type=Command.CommandType.CONFIGURATION)
    public void dropAllChanges() {
        this.dropChangesInternal(this.categories);
    }

    @Command(description="drop unsaved changes for the specified categories", type=Command.CommandType.CONFIGURATION)
    public void dropChangesForCategories(String ... categories) {
        this.dropChangesInternal(ConfigUtils.parseCategories(this.categories, (String[])categories));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropChangesInternal(Set<String> categoriesSet) {
        Object object = this.configLock;
        synchronized (object) {
            this.checkValidStates(true, true);
            try {
                this.configurationHandler.dropChangesForCategories(categoriesSet);
                ConfigurationInfo ci = this.configurationHandler.getConfigurationInfo();
                this.updateStateAndSendStatusConfigurationInfo(ci);
            }
            catch (RuntimeException ex) {
                this.handleException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="loads a new configuration", type=Command.CommandType.CONFIGURATION)
    public void loadConfiguration(String ... taggedCategories) {
        Object object = this.configLock;
        synchronized (object) {
            this.checkValidStates(false, false);
            this.loadCategoriesInternal(ConfigUtils.parseConfigurationStringWithDefaults(this.categories, (String[])taggedCategories));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="loads the configuration for the specified categories", type=Command.CommandType.CONFIGURATION)
    public void loadCategories(String ... taggedCategories) {
        if (taggedCategories.length == 0) {
            return;
        }
        Object object = this.configLock;
        synchronized (object) {
            this.checkValidStates(true, true);
            this.loadCategoriesInternal(ConfigUtils.parseConfigurationString(this.categories, (String[])taggedCategories));
        }
    }

    private void loadCategoriesInternal(Map<String, String> taggedCategories) {
        try {
            this.configurationHandler.loadCategories(taggedCategories);
            ConfigurationInfo ci = this.configurationHandler.getConfigurationInfo();
            this.updateStateAndSendStatusConfigurationInfo(ci);
        }
        catch (RuntimeException ex) {
            this.handleException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="return a ConfigurationInfo object", type=Command.CommandType.CONFIGURATION)
    public ConfigurationInfo getConfigurationInfo() {
        Object object = this.configLock;
        synchronized (object) {
            return this.configurationHandler.getConfigurationInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="Submits a single change to be processed immediately", type=Command.CommandType.CONFIGURATION)
    public void change(String componentName, String parameterName, Object value) {
        this.checkValidStates(true, true);
        Object object = this.configLock;
        synchronized (object) {
            try {
                this.configurationHandler.setSingleParameter(componentName, parameterName, value);
                ConfigurationInfo ci = this.configurationHandler.getConfigurationInfo();
                this.updateStateAndSendStatusConfigurationInfo(ci);
            }
            catch (RuntimeException ex) {
                this.handleException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="Submits a change of parameter to be validated later", type=Command.CommandType.CONFIGURATION)
    public void submitChange(String componentName, String parameterName, Object value) {
        this.checkValidStates(true, true);
        Object object = this.configLock;
        synchronized (object) {
            this.configurationHandler.submitChange(componentName, parameterName, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="Submits changes of parameters to be validated later", type=Command.CommandType.CONFIGURATION)
    public void submitChanges(String componentName, Map<String, Object> changes) {
        this.checkValidStates(true, true);
        Object object = this.configLock;
        synchronized (object) {
            for (Map.Entry<String, Object> entry : changes.entrySet()) {
                this.configurationHandler.submitChange(componentName, entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="processes the bulk change", type=Command.CommandType.CONFIGURATION)
    public void commitBulkChange() {
        Object object = this.configLock;
        synchronized (object) {
            this.checkValidStates(true, true);
            ConfigurationInfo ci = null;
            try {
                this.configurationHandler.commitBulkChange(Collections.emptyMap());
                ci = this.configurationHandler.getConfigurationInfo();
                this.updateStateAndSendStatusConfigurationInfo(ci);
                conf_sub_log.info((Object)(ci.getLatestChanges().size() + " successfully set parameters"));
            }
            catch (RuntimeException ex) {
                this.handleException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="Drops the submitted changes for all components", type=Command.CommandType.CONFIGURATION)
    public void dropAllSubmittedChanges() {
        Object object = this.configLock;
        synchronized (object) {
            this.configurationHandler.dropAllSubmittedChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="Drops the submitted changes for the given component", type=Command.CommandType.CONFIGURATION)
    public void dropSubmittedChangesForComponent(@Argument(description="the component name") String name) {
        Object object = this.configLock;
        synchronized (object) {
            this.configurationHandler.dropSubmittedChangesForComponent(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="Returns the current submitted changes for the given component", type=Command.CommandType.CONFIGURATION)
    public Map<String, String> getSubmittedChangesForComponent(@Argument(description="the component name") String name) {
        Object object = this.configLock;
        synchronized (object) {
            return this.configurationHandler.getSubmittedChangesForComponent(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="Returns the current submitted changes for each component", type=Command.CommandType.CONFIGURATION)
    public Map<String, Map<String, String>> getAllSubmittedChanges() {
        Object object = this.configLock;
        synchronized (object) {
            return this.configurationHandler.getAllSubmittedChanges();
        }
    }

    @Command(description="returns the categories of this subsystem")
    public Set<String> getCategories() {
        return Collections.unmodifiableSet(this.categories);
    }

    @Command(description="returns the available configurations for the given category")
    public Set<String> findAvailableConfigurationsForCategory(String category) {
        try {
            return this.configurationHandler.findAvailableConfigurationsForCategory(category);
        }
        catch (ConfigurationServiceException ex) {
            this.subsystem.raiseAlert(CS_ALERT_1, AlertState.ALARM, ex.getMessage());
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="returns the current values for a given component that belong to the specified categories")
    public Map<String, String> getCurrentValuesForComponent(String componentName, Set<String> categorySet) {
        Object object = this.configLock;
        synchronized (object) {
            return this.configurationHandler.getCurrentValuesForComponent(componentName, categorySet);
        }
    }

    @Command
    public boolean isParameterConfigurable(String componentName, String parameterName) {
        return this.configurationHandler.isParameterConfigurable(componentName, parameterName);
    }

    public String getTag() {
        return this.configurationHandler.getDescriptionName();
    }

    private void updateStateAndSendStatusConfigurationInfo(ConfigurationInfo ci) {
        this.subsystem.updateInternalState(new AgentState[]{ci.getConfigurationState()});
        this.subsystem.getMessagingAccess().sendStatusMessage((StatusMessage)new StatusConfigurationInfo(ci, this.subsystem.getState()));
    }

    private void checkValidStates(boolean failIfNotEM, boolean failIfInitialSafe) {
        ConfigurationState configState;
        if (this.subsystem.getState(PhaseState.class) == null) {
            throw new IllegalStateException("Configuration commands are accepted only when the subsystem is connected on the buses");
        }
        if (failIfInitialSafe && ((configState = (ConfigurationState)this.subsystem.getState(ConfigurationState.class)) == null || configState == ConfigurationState.INITIAL_SAFE)) {
            throw new IllegalStateException("A full configuration load must be performed first, using loadConfiguration");
        }
        if (failIfNotEM && !this.subsystem.isInEngineeringMode()) {
            throw new IllegalStateException("Fine grained configuration actions are accepted only in engineering mode");
        }
    }

    private void handleException(RuntimeException ex) {
        ConfigurationInfo ci = this.configurationHandler.getConfigurationInfo();
        this.updateStateAndSendStatusConfigurationInfo(ci);
        if (ex instanceof ConfigurationServiceException) {
            this.subsystem.raiseAlert(CS_ALERT_1, AlertState.ALARM, ex.getMessage());
        } else if (ex instanceof BulkSettingException) {
            this.subsystem.raiseAlert(CS_ALERT_2, AlertState.ALARM, ex.getMessage());
        }
        throw ex;
    }
}

