/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.util.concurrent.TimeUnit;
import org.lsst.ccs.Agent;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.utilities.scheduler.PeriodicTask;

public class PeriodicTaskComponent
implements HasLifecycle {
    private final PeriodicTask task;
    private final Object taskLock = new Object();
    @ConfigurationParameter(category="timers")
    private long taskPeriodMillis = -1L;
    private boolean hasBeenStarted = false;

    PeriodicTaskComponent(AgentPeriodicTask t, Agent a) {
        this.task = new PeriodicTask(a.getScheduler(), t.getRunnable(), t.isIsFixedRate(), t.getTaskName(), t.getLogLevel(), t.getPeriod(), t.getUnit());
        if (this.task == null) {
            throw new RuntimeException("The PeriodicTask cannot be null");
        }
        if (this.task.getTaskName().isEmpty()) {
            throw new RuntimeException("The PeriodicTask cannot have an empty name");
        }
        this.taskPeriodMillis = this.task.getPeriod(TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ConfigurationParameterChanger(propertyName="taskPeriodMillis")
    public void setTaskPeriodMillis(long taskPeriodMillis) {
        Object object = this.taskLock;
        synchronized (object) {
            if (this.taskPeriodMillis != taskPeriodMillis) {
                this.taskPeriodMillis = taskPeriodMillis;
                if (this.hasBeenStarted) {
                    this.task.stop();
                    if (taskPeriodMillis > 0L) {
                        this.task.setPeriod(taskPeriodMillis, TimeUnit.MILLISECONDS);
                        this.task.start();
                    }
                }
            }
        }
    }

    public long getTaskPeriodMillis() {
        return this.taskPeriodMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTask() {
        if (this.hasBeenStarted) {
            return;
        }
        this.hasBeenStarted = true;
        Object object = this.taskLock;
        synchronized (object) {
            if (this.taskPeriodMillis > 0L) {
                this.task.setPeriod(this.taskPeriodMillis, TimeUnit.MILLISECONDS);
                this.task.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopTask() {
        Object object = this.taskLock;
        synchronized (object) {
            this.task.stop();
        }
    }

    @Override
    public void shutdownNow() {
        this.stopTask();
    }

    @Override
    public void postStart() {
        this.startTask();
    }

    PeriodicTask getTask() {
        return this.task;
    }
}

