/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.python.core.Py;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyDataDescr;
import org.python.core.PyException;
import org.python.core.PyIterator;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyType;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules.PyTeeIterator$exposed___new__;
import org.python.modules.PyTeeIterator$tee_next_exposer;
import org.python.util.Generic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExposedType(name="itertools.tee", base=PyObject.class, isBaseType=false)
public class PyTeeIterator
extends PyIterator {
    private final int position;
    private int count = 0;
    private final PyObject iterator;
    private final Map<Integer, PyObject> buffer;
    private final int[] offsets;

    PyTeeIterator(PyObject iterator, Map<Integer, PyObject> buffer, int[] offsets, int position) {
        this.iterator = iterator;
        this.buffer = buffer;
        this.offsets = offsets;
        this.position = position;
    }

    @ExposedNew
    static final PyObject tee___new__(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        int nargs = args.length;
        if (nargs < 1 || nargs > 1) {
            throw Py.TypeError("tee expected 1 arguments, got " + nargs);
        }
        return PyTeeIterator.makeTees(args[0], 1)[0];
    }

    public static PyTeeIterator[] makeTees(PyObject iterable, int n) {
        if (n < 0) {
            throw Py.ValueError("n must be >= 0");
        }
        PyObject iterator = iterable.__iter__();
        ConcurrentMap<Integer, PyObject> buffer = Generic.concurrentMap();
        int[] offsets = new int[n];
        PyTeeIterator[] tees = new PyTeeIterator[n];
        for (int i = 0; i < n; ++i) {
            offsets[i] = -1;
            tees[i] = new PyTeeIterator(iterator, buffer, offsets, i);
        }
        return tees;
    }

    protected PyObject nextElement(PyObject pyIter) {
        PyObject element = null;
        try {
            element = pyIter.__iternext__();
        }
        catch (PyException pyEx) {
            if (pyEx.match(Py.StopIteration)) {
                this.stopException = pyEx;
            }
            throw pyEx;
        }
        return element;
    }

    public final PyObject tee_next() {
        return this.next();
    }

    @Override
    public PyObject __iternext__() {
        PyObject pyObject;
        int n = Integer.MIN_VALUE;
        int max = Integer.MAX_VALUE;
        for (int min = 0; min < this.offsets.length; ++min) {
            if (n < this.offsets[min]) {
                n = this.offsets[min];
            }
            if (max <= this.offsets[min]) continue;
            max = this.offsets[min];
        }
        if (this.count > n) {
            pyObject = this.nextElement(this.iterator);
            if (pyObject != null) {
                this.buffer.put(this.count, pyObject);
            }
        } else {
            pyObject = this.count < max ? this.buffer.remove(this.count) : this.buffer.get(this.count);
        }
        this.offsets[this.position] = this.count++;
        return pyObject;
    }

    static {
        PyType.addBuilder(PyTeeIterator.class, new PyTeeIterator$PyExposer());
    }

    public class PyTeeIterator$PyExposer
    extends BaseTypeBuilder {
        public PyTeeIterator$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new PyTeeIterator$tee_next_exposer("next")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{};
            super("itertools.tee", PyTeeIterator.class, PyObject.class, false, null, pyBuiltinMethodArray, pyDataDescrArray, new PyTeeIterator$exposed___new__());
        }
    }
}

