package org.lsst.ccs.gconsole.plugins.plots;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.Plugin;

/**
 * Graphical console plugin that displays AIDA plots published on the status bus.
 * @author turri
 */
@Plugin(name="LSST Plots Plugin",
        description="Allows displaying AIDA plots published on the status bus.")
public class LsstPlotsPlugin extends ConsolePlugin {

// -- Fields : -----------------------------------------------------------------
    
    private final Action plotsAction;
    private PlotsListener plotListener;

// -- Life cycle : -------------------------------------------------------------
    
    public LsstPlotsPlugin() {
        plotsAction = new AbstractAction("Plots") {
            @Override
            public void actionPerformed(ActionEvent e) {
                LsstPlotsPlugin.this.setEnabled((Boolean) getValue(Action.SELECTED_KEY));
            }
        };
        plotsAction.putValue(Action.SELECTED_KEY, false);
    }
    
    @Override
    synchronized public void initialize(){
        getServices().addMenu(plotsAction, "400: CCS Tools :-1:7");
    }
    
    synchronized public void setEnabled(boolean enable) {
        plotsAction.putValue(Action.SELECTED_KEY, enable);
        if (enable) {
            plotListener = new PlotsListener();
            getConsole().getMessagingAccess().addStatusMessageListener(plotListener);
        } else {
            getConsole().getMessagingAccess().removeStatusMessageListener(plotListener);
            plotListener = null;
        }
    }

}
