package org.lsst.ccs.gconsole.plugins.monitor;

import java.util.*;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

/**
 * Panel that displays monitoring data as a tree of simple tables.
 * FOR TESTING ONLY.
 *
 * @author onoprien
 */
public class SimpleDataTree extends JTree implements DataView {

// -- Fields : -----------------------------------------------------------------
    
    private String name;
    private final HashMap<String,ChannelNode> path2node = new HashMap<>();
    
// -- Life cycle : -------------------------------------------------------------
     
    public SimpleDataTree() {
        setRootVisible(false);
        setShowsRootHandles(true);
    }
    
    
// -- Updates : ----------------------------------------------------------------
    
    @Override
    public void setName(String name) {
        this.name = name;
    }
    
    @Override
    public String getName() {
        return name;
    }

    @Override
    public void setChannels(LinkedHashMap<String, Channel> channels) {
        
        path2node.clear();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        
        for (Map.Entry<String, Channel> e : channels.entrySet()) {
            String[] tpath = getPath(e.getKey());
            DefaultMutableTreeNode parent = root;
            DefaultMutableTreeNode node = null;
            for (int level=0; level < tpath.length-1; level++) {
                int n = parent.getChildCount();
                while (n-- > 0) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode) parent.getChildAt(n);
                    if (child.toString().equals(tpath[level])) {
                        node = child;
                        break;
                    }
                }
                if (node == null) {
                    node = new DefaultMutableTreeNode(tpath[level]);
                    parent.add(node);
                }
                parent = node;
                node = null;
            }
            ChannelNode leaf = new ChannelNode(tpath[tpath.length-1], e.getValue());
            path2node.put(e.getKey(), leaf);
            parent.add(leaf);
        }
        
        setModel(new DefaultTreeModel(root));
        
    }

    @Override
    public void addChannel(String path, Channel channel) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeChannel(String path) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void update(String path, Channel channel) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void update(String path) {
        ChannelNode node = path2node.get(path);
        if (node != null) {
            getModel().nodeChanged(node);
        }
    }

    @Override
    public void update(String path, Field field) {
        update(path);
    }

    @Override
    public void update(String path, EnumSet<Field> fields) {
        update(path);
    }

    @Override
    public JComponent getView() {
        return this;
    }
    
    
// -- Customizing tree : -------------------------------------------------------
    
    @Override
    public DefaultTreeModel getModel() {
        return (DefaultTreeModel) super.getModel();
    }
    
    
// -- Tree model : -------------------------------------------------------------
    
//    private class Model extends DefaultTreeModel {
//                
//    }

// -- Local classes : ----------------------------------------------------------
    
    class ChannelNode extends DefaultMutableTreeNode {
        
        private String text;
        private Channel channel;
        
        ChannelNode(String text, Channel channel) {
            this.text = text;
            this.channel = channel;
        }

        @Override
        public String toString() {
            return text +" "+ channel.getValue();
        }
        
    }
    
    
// -- LOcal methods : ----------------------------------------------------------
    
    String[] getPath(String displayPath) {
        int i = displayPath.indexOf("//");
        if (i != -1) displayPath = displayPath.substring(i+2);
        return displayPath.split("/");
    }
       
}
