package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.Component;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Properties;
import javax.swing.JComponent;
import org.freehep.application.Application;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.mdi.PageEvent;
import org.freehep.application.mdi.PageListener;
import org.freehep.application.mdi.PageManager;
import org.freehep.application.studio.Studio;
import org.freehep.graphicsbase.util.export.ExportDialog;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.gconsole.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.messaging.StatusMessageListener;

/**
 * Graphical console plugin that supports display of monitoring data.
 *
 * @author onoprien
 */
@Plugin(name="LSST Monitoring Plugin",
        id="monitor",
        description="LSST CCS monitoring data display service.")
public class LsstMonitorPlugin extends ConsolePlugin implements StatusMessageListener {

// -- Fields : -----------------------------------------------------------------
    
    private final Studio app = (Studio) Application.getApplication();

// -- Life cycle : -------------------------------------------------------------

    @Override
    public void initialize() {
        
        PageManager pm = app.getPageManager();
        pm.addPageListener(new Saver());
        
    }
    
    
// -- Static services : --------------------------------------------------------
    
    
    
// -- Access to accumulated data : ---------------------------------------------
    
    public Object getData(String path, Field field) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
    
    // Should this return an unmodifiable EnumMap ?
    public Object[] getData(String path) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
    
// -- Handling listeners and updates : -----------------------------------------
    
    public interface Listener {
        
        void enabled(Event event);
        
        void fullStateReceived(Event event);
        
        void update(Event event);
        
    }
    
    public static class Event {
        
    }
    
    public void openPanel(MonitorFilter filter) {
        
    }
    
    public void closePanel(MonitorFilter filter) {
        
    }
    
    public void addListener(Listener listener, MonitorFilter filter) {
        
    }
    
    public void removeListener(Listener listener) {
        
    }

    @Override
    public void onStatusMessage(StatusMessage msg) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
        
    
// -- Temporary code for saving monitoring pages : -----------------------------
    
    private class Saver extends CommandProcessor implements PageListener {
        
        private boolean on;

        @Override
        public void pageChanged(PageEvent pe) {
            PageContext context = pe.getPageContext();
            if (context == null) return;
            JComponent panel = (JComponent) context.getPage();
            if (panel == null) return;
            switch (pe.getID()) {
                case PageEvent.PAGESELECTED:
                    MonitorDisplay md = findMonitorDisplay(panel, false);
                    if (md == null) {
                        if (on) {
                            app.getCommandTargetManager().remove(this);
                            on = false;
                        }
                    } else {
                        if (!on) {
                            app.getCommandTargetManager().add(this);
                            on = true;
                        }
                    }
                    break;
                case PageEvent.PAGEDESELECTED:
//                    if (on) {
//                        app.getCommandTargetManager().remove(this);
//                        on = false;
//                    }
                    break;
            }
        }
        
        private MonitorDisplay findMonitorDisplay(JComponent component, boolean visibleOnly) {
            if (visibleOnly && !component.isShowing()) {
                return null;
            }
            if (component instanceof MonitorDisplay) {
                return (MonitorDisplay) component;
            }
            Component[] cc = component.getComponents();
            for (Component c : cc) {
                if (c instanceof JComponent) {
                    MonitorDisplay md = findMonitorDisplay((JComponent)c, visibleOnly);
                    if (md != null) return md;
                }
            }
            return null;
        } 
        
        public void onSaveAs() {
            try {
                PageManager pm = app.getPageManager();
                PageContext context = pm.getSelectedPage();
                JComponent component = (JComponent) context.getPage();
                MonitorDisplay md = findMonitorDisplay(component, true);

                Properties user = app.getUserProperties();
                String creator = "creator";
                ExportDialog dlg = new ExportDialog(creator, false);
                dlg.addExportFileType(new MonitorExport());
                dlg.addExportFileType(new MonitorExport()); // working around the bug in ExportDialog line 160
                dlg.setUserProperties(user);
                dlg.showExportDialog(app, "Save As...", (Component)md, "monitor");
            } catch (NullPointerException|ClassCastException x) {
                app.error("No selected monitoring table", x);
            }
        }
        
    }
    
    static public void saveData(OutputStream out, String mimeType, List<Channel> channels) {
        
        PrintStream ps = new PrintStream(out);
        int n = Field.values().length;
        
        StringBuilder sb = new StringBuilder();
        for (Field field : Field.values()) {
            sb.append(field).append(",");
        }      
        ps.println(sb.substring(0, sb.length()-1));
        
        for (Channel channel : channels) {
            sb = new StringBuilder();
            for (Field field : Field.values()) {
                sb.append(channel.get(field)).append(",");
            }
            ps.println(sb.substring(0, sb.length()-1));
        }
        
    }

}
