/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shell;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jline.console.ConsoleReader;
import org.lsst.ccs.BusMaster;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.RouteSelectionCommandSet;
import org.lsst.ccs.command.RoutingCommandSet;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.AgentPresenceManager;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.scripting.jython.JythonScriptExecutorUtils;
import org.lsst.ccs.shell.JLineShell;
import org.lsst.ccs.subsystem.shell.BusCommandSet;
import org.lsst.ccs.subsystems.console.jython.JythonConsoleSocketConnection;

public class ConsoleCommandShell
implements AgentPresenceListener {
    private final AgentMessagingLayer messagingAccess;
    private final RouteSelectionCommandSet rsc;
    private final CompositeCommandSet ccs;
    private final ConcurrentMessagingUtils sci;
    private final BusMasterCommands busMasterCommands = new BusMasterCommands();
    private static final int timeoutMillis = 10000;
    private final Map<String, RoutingCommandSet> routes = new LinkedHashMap<String, RoutingCommandSet>();
    private JythonConsoleSocketConnection jythonConsoleSocketConnection = null;
    private String showJythonOutput = "false";

    ConsoleCommandShell(AgentMessagingLayer messagingAccess) {
        this.messagingAccess = messagingAccess;
        this.sci = new ConcurrentMessagingUtils(messagingAccess, Duration.ofMillis(10000L));
        CommandSetBuilder builder = new CommandSetBuilder();
        this.ccs = new CompositeCommandSet();
        this.ccs.add(builder.buildCommandSet((Object)this.busMasterCommands));
        this.rsc = new RouteSelectionCommandSet(this.ccs);
    }

    void init() {
        AgentPresenceManager apMan = this.messagingAccess.getAgentPresenceManager();
        apMan.addAgentPresenceListener((AgentPresenceListener)this);
    }

    public CompositeCommandSet getConsoleCommandSet() {
        return this.rsc;
    }

    public void connecting(AgentInfo agent) {
        if (!(agent.getType().equals((Object)AgentInfo.AgentType.LISTENER) || agent.getType().equals((Object)AgentInfo.AgentType.CONSOLE) || this.routes.containsKey(agent.getName()))) {
            AddSubsystem add = new AddSubsystem(agent.getName());
            Thread t = new Thread(add);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnecting(AgentInfo agent) {
        String agentName = agent.getName();
        ConsoleCommandShell consoleCommandShell = this;
        synchronized (consoleCommandShell) {
            Iterator<Map.Entry<String, RoutingCommandSet>> it = this.routes.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, RoutingCommandSet> e = it.next();
                String routeName = e.getKey();
                if (!routeName.equals(agentName) && !routeName.startsWith(agentName + "/")) continue;
                this.ccs.remove((CommandSet)e.getValue());
                it.remove();
            }
        }
    }

    BusMasterCommands getBusMasterCommands() {
        return this.busMasterCommands;
    }

    synchronized Map<String, RoutingCommandSet> getRoutes() {
        return this.routes;
    }

    public static JLineShell createJLineShell(AgentMessagingLayer messagingAccess, ConsoleReader reader) throws IOException {
        ConsoleCommandShell comShell = new ConsoleCommandShell(messagingAccess);
        comShell.init();
        return new JLineShell((CommandSet)comShell.getConsoleCommandSet(), reader, "${target} ccs>");
    }

    public static void main(String[] argv) throws Exception {
        BusMaster busMaster = new BusMaster("console");
        busMaster.start();
        ConsoleCommandShell comShell = new ConsoleCommandShell(busMaster.getMessagingAccess());
        JLineShell shell = new JLineShell((CommandSet)comShell.getConsoleCommandSet(), "${target} ccs>");
        comShell.init();
        shell.run();
        System.exit(0);
    }

    private class AddSubsystem
    implements Runnable {
        private final String agentName;

        AddSubsystem(String name) {
            this.agentName = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                CommandRequest getDictionaryCommand = new CommandRequest(this.agentName, "getDictionaries");
                HashMap dictionaries = (HashMap)ConsoleCommandShell.this.sci.sendSynchronousCommand(getDictionaryCommand);
                ConsoleCommandShell consoleCommandShell = ConsoleCommandShell.this;
                synchronized (consoleCommandShell) {
                    for (String path : dictionaries.keySet()) {
                        int first = path.indexOf("/");
                        int last = path.lastIndexOf("/");
                        String name = path;
                        if (first != last) {
                            name = path.substring(0, first) + path.substring(last);
                        }
                        this.addDictionary(name, path, (Dictionary)dictionaries.get(path));
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void addDictionary(String routeName, String name, Dictionary dictionary) {
            if (ConsoleCommandShell.this.routes.containsKey(routeName)) {
                throw new RuntimeException("Error: Route " + routeName + " already exist");
            }
            RoutingCommandSet crcs = new RoutingCommandSet(routeName, (CommandSet)new BusCommandSet(ConsoleCommandShell.this.sci, name, dictionary));
            ConsoleCommandShell.this.ccs.add((CommandSet)crcs);
            ConsoleCommandShell.this.routes.put(routeName, crcs);
        }
    }

    public class BusMasterCommands {
        @Command(name="listSubsystems", description="List the subsystems on the CCS buses for a given Agent type", alias="ls")
        public List<String> listSubsystems() {
            return this.listSubsystems("Worker", true);
        }

        @Command(name="listSubsystems", description="List the subsystems on the CCS buses for a given Agent type", alias="ls")
        public List<String> listSubsystems(@Argument(name="Agent type") String agentType, @Argument(defaultValue="true") boolean allTypesAbove) {
            AgentInfo.AgentType referenceType = AgentInfo.AgentType.valueOf((String)agentType.toUpperCase());
            ArrayList<String> result = new ArrayList<String>();
            for (AgentInfo agent : ConsoleCommandShell.this.messagingAccess.getAgentPresenceManager().listConnectedAgents()) {
                if (allTypesAbove) {
                    if (agent.getType().ordinal() < referenceType.ordinal()) continue;
                    result.add(agent.getName());
                    continue;
                }
                if (agent.getType().ordinal() != referenceType.ordinal()) continue;
                result.add(agent.getName());
            }
            return result;
        }

        @Command(description="Set Console parameters")
        public void set(@Argument(name="item") ConsoleParameters what, @Argument(name="value") String value) {
            if (what == ConsoleParameters.TIMEOUT) {
                ConsoleCommandShell.this.sci.setDefaultTimeout(Duration.ofMillis(Long.valueOf(value)));
            } else if (what == ConsoleParameters.SHOW_JYTHON_OUTPUT) {
                if (ConsoleCommandShell.this.jythonConsoleSocketConnection != null) {
                    ConsoleCommandShell.this.jythonConsoleSocketConnection.setPrintStream(value.equals("true") ? System.out : null);
                }
                ConsoleCommandShell.this.showJythonOutput = value;
            }
        }

        @Command(description="Get a Console parameter")
        public String get(@Argument(name="item") ConsoleParameters what) {
            if (what == ConsoleParameters.TIMEOUT) {
                return String.valueOf(ConsoleCommandShell.this.sci.getDefaultTimeout().toMillis());
            }
            if (what == ConsoleParameters.SHOW_JYTHON_OUTPUT) {
                return ConsoleCommandShell.this.showJythonOutput;
            }
            return null;
        }

        @Command(description="Execute a Jython script")
        public void executeScript(@Argument(name="scriptPath") String scriptPath, String ... args) throws IOException {
            JythonScriptExecutorUtils.executeScript(scriptPath, args);
        }

        @Command(description="Submit a Jython script to a Jython Interpreter")
        public void connectToJythonConsole(@Argument(name="host", defaultValue="localhost") String host, @Argument(name="port", defaultValue="4444") int port) throws IOException {
            if (ConsoleCommandShell.this.jythonConsoleSocketConnection != null) {
                throw new RuntimeException("There is already a connection established. There can be only one! Please \"closeConnectionWithJythonConsole\" before opening a new one.");
            }
            ConsoleCommandShell.this.jythonConsoleSocketConnection = new JythonConsoleSocketConnection("CommandShellConnection_" + System.currentTimeMillis(), port, host);
            ConsoleCommandShell.this.jythonConsoleSocketConnection.setPrintStream(ConsoleCommandShell.this.showJythonOutput.equals("true") ? System.out : null);
        }

        @Command(description="Submit a Jython script to a Jython Interpreter")
        public void submitScript(@Argument(name="scriptPath") String scriptPath, String ... args) throws IOException {
            if (ConsoleCommandShell.this.jythonConsoleSocketConnection == null) {
                throw new RuntimeException("No connection was established with a JythonConsole. Please invoke \"connectToJythonConsole\" first");
            }
            ConsoleCommandShell.this.jythonConsoleSocketConnection.asynchFileExecution(scriptPath, args);
        }

        @Command(description="Submit a Jython script to a Jython Interpreter")
        public void closeConnectionWithJythonConsole() throws IOException {
            if (ConsoleCommandShell.this.jythonConsoleSocketConnection == null) {
                throw new RuntimeException("There is open connection to a JythonConsole.");
            }
            ConsoleCommandShell.this.jythonConsoleSocketConnection.close();
            ConsoleCommandShell.this.jythonConsoleSocketConnection = null;
        }
    }

    public static enum ConsoleParameters {
        TIMEOUT,
        SHOW_JYTHON_OUTPUT;

    }
}

