/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup;

import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.startup.BootUtils;

public class SubsystemBoot {
    static String descriptionName;
    static String configurationFileName;
    static String subsystemAlias;

    public static void main(String[] args) throws Exception {
        SubsystemBoot.parseArgsCLI(args);
        if (descriptionName == null) {
            throw new IllegalArgumentException("no description specification");
        }
        if (descriptionName.endsWith(".xml")) {
            throw new IllegalArgumentException("Spring no longer supported");
        }
        Subsystem subsystem = BootUtils.getSubsystemFromFile(descriptionName, configurationFileName, subsystemAlias);
        subsystem.start();
    }

    static void parseArgsCLI(String[] args) {
        Options commandLineOptions = new Options();
        commandLineOptions.addOption("h", "help", false, "Print the help message");
        commandLineOptions.addOption("v", "verbose", false, "Turns on verbose statements");
        commandLineOptions.addOption("d", "description", true, "Name of Subsystem description file.");
        commandLineOptions.getOption("description").setArgName("DESCRIPTION_FILE");
        commandLineOptions.addOption("c", "configuration", true, "Name of Configuration properties file.");
        commandLineOptions.getOption("configuration").setArgName("CONFIGURATION_FILE");
        commandLineOptions.addOption("a", "alias", true, "Name of subsystem on the buses.");
        commandLineOptions.getOption("alias").setArgName("SUBSYSTEM_NAME");
        BasicParser parser = new BasicParser();
        try {
            CommandLine line = parser.parse(commandLineOptions, args, false);
            if (line.hasOption("help")) {
                SubsystemBoot.usageCLI(commandLineOptions);
            } else {
                descriptionName = line.getOptionValue("description");
                configurationFileName = line.getOptionValue("configuration");
                subsystemAlias = line.getOptionValue("alias");
            }
        }
        catch (Exception e) {
            SubsystemBoot.usageCLI(commandLineOptions);
        }
    }

    static void usageCLI(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(100, "SubsystemBoot", "", options, "", true);
        System.exit(0);
    }

    static {
        subsystemAlias = null;
    }
}

