/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.lsst.ccs.gconsole.plugins.monitor.Channel;
import org.lsst.ccs.gconsole.plugins.monitor.DataView;
import org.lsst.ccs.gconsole.plugins.monitor.Field;

public class SimpleDataTree
extends JTree
implements DataView {
    private String name;
    private final HashMap<String, ChannelNode> path2node = new HashMap();

    public SimpleDataTree() {
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setChannels(LinkedHashMap<String, Channel> channels) {
        this.path2node.clear();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        for (Map.Entry<String, Channel> e : channels.entrySet()) {
            String[] tpath = this.getPath(e.getKey());
            DefaultMutableTreeNode parent = root;
            DefaultMutableTreeNode node = null;
            for (int level = 0; level < tpath.length - 1; ++level) {
                int n = parent.getChildCount();
                while (n-- > 0) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)parent.getChildAt(n);
                    if (!child.toString().equals(tpath[level])) continue;
                    node = child;
                    break;
                }
                if (node == null) {
                    node = new DefaultMutableTreeNode(tpath[level]);
                    parent.add(node);
                }
                parent = node;
                node = null;
            }
            ChannelNode leaf = new ChannelNode(tpath[tpath.length - 1], e.getValue());
            this.path2node.put(e.getKey(), leaf);
            parent.add(leaf);
        }
        this.setModel(new DefaultTreeModel(root));
    }

    @Override
    public void addChannel(String path, Channel channel) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeChannel(String path) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void update(String path, Channel channel) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void update(String path) {
        ChannelNode node = this.path2node.get(path);
        if (node != null) {
            this.getModel().nodeChanged(node);
        }
    }

    @Override
    public void update(String path, Field field) {
        this.update(path);
    }

    @Override
    public void update(String path, EnumSet<Field> fields) {
        this.update(path);
    }

    @Override
    public JComponent getView() {
        return this;
    }

    @Override
    public DefaultTreeModel getModel() {
        return (DefaultTreeModel)super.getModel();
    }

    String[] getPath(String displayPath) {
        int i = displayPath.indexOf("//");
        if (i != -1) {
            displayPath = displayPath.substring(i + 2);
        }
        return displayPath.split("/");
    }

    class ChannelNode
    extends DefaultMutableTreeNode {
        private String text;
        private Channel channel;

        ChannelNode(String text, Channel channel) {
            this.text = text;
            this.channel = channel;
        }

        @Override
        public String toString() {
            return this.text + " " + this.channel.getValue();
        }
    }
}

