/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import org.freehep.application.studio.Studio;
import org.lsst.ccs.gconsole.plugins.monitor.Channel;
import org.lsst.ccs.gconsole.plugins.monitor.DataView;
import org.lsst.ccs.gconsole.plugins.monitor.Field;
import org.lsst.ccs.gconsole.plugins.monitor.LsstMonitorPlugin;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorDisplay;
import org.lsst.ccs.gconsole.plugins.trending.TrendingService;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;

public class DataTree
implements DataView {
    private static final int NFIELDS = Field.values().length;
    private static final Color COLOR_GOOD = new Color(160, 255, 160);
    private static final Color COLOR_WARN = new Color(255, 255, 100);
    private static final Color COLOR_ERR = new Color(255, 160, 160);
    private static final Color COLOR_OFF = new Color(160, 200, 255);
    private static final Color COLOR_POPUP = new Color(255, 255, 160);
    static final Font FONT_PLAIN = new Font("Helvetica", 0, 12);
    static final String MULTI_VALUE = "_m_";
    private final CommandSender sender;
    private String name;
    private final Tree tree;
    private DataNode dataRoot;
    private final HashMap<String, DataNodeLeaf> path2data = new HashMap();

    public DataTree(CommandSender sender) {
        this.sender = sender;
        this.tree = new Tree();
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setRowHeight(0);
        this.tree.setCellRenderer(new TreeRenderer(false));
        this.tree.setCellEditor(new TreeEditor());
        this.tree.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (DataTree.this.tree.getRowForLocation(e.getX(), e.getY()) != -1) {
                    DataTree.this.tree.startEditingAtPath(DataTree.this.tree.getPathForLocation(e.getX(), e.getY()));
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
            }
        });
        this.tree.setEditable(true);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setChannels(LinkedHashMap<String, Channel> channels) {
        this.buildDataTree(channels);
        DefaultMutableTreeNode root = this.buildTreeModel(this.dataRoot, true);
        this.tree.setModel(new DefaultTreeModel(root));
        List<DataNodeLeaf> leaves = this.dataRoot.appendLeaves(new ArrayList<DataNodeLeaf>());
        leaves.forEach(leaf -> this.tree.expandPath(new TreePath(leaf.parent.parent.modelNode.getPath())));
    }

    @Override
    public void addChannel(String path, Channel channel) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeChannel(String path) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void update(String path, Channel channel) {
        DataNodeLeaf leaf = this.path2data.get(path);
        if (leaf != null) {
            leaf.update(channel, null);
        }
    }

    @Override
    public void update(String path) {
        this.update(path, (Channel)null);
    }

    @Override
    public void update(String path, Field field) {
        DataNodeLeaf leaf = this.path2data.get(path);
        if (leaf != null) {
            leaf.update(null, field);
        }
    }

    @Override
    public void update(String path, EnumSet<Field> fields) {
        this.update(path);
    }

    @Override
    public JComponent getView() {
        return this.tree;
    }

    JTable createTable(AnyTableModel model) {
        JTable table = new JTable(model);
        JTableHeader hdr = table.getTableHeader();
        hdr.setReorderingAllowed(false);
        hdr.setSize(hdr.getWidth(), hdr.getHeight() + 2);
        table.setDefaultRenderer(Object.class, new TableRenderer());
        table.setAutoResizeMode(3);
        table.setRowSelectionAllowed(false);
        table.setColumnSelectionAllowed(false);
        table.setFont(FONT_PLAIN);
        table.setRowHeight(table.getRowHeight() + 2);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DataTree.this.tableMouseClicked(evt);
            }
        });
        return table;
    }

    private void tableMouseClicked(MouseEvent evt) {
        Object value;
        int nClick = evt.getClickCount();
        JTable table = (JTable)evt.getSource();
        Point point = evt.getPoint();
        int row = table.rowAtPoint(point);
        int column = table.columnAtPoint(point);
        if (nClick != 1 && nClick == 2 && (value = table.getValueAt(row, column)) instanceof ValueHolder) {
            ValueHolder vh = (ValueHolder)value;
            String[] path = new String[]{vh.channel.getSubsystemName(), vh.channel.getName()};
            Studio studio = (Studio)Studio.getApplication();
            if (studio == null) {
                return;
            }
            TrendingService trending = (TrendingService)studio.getLookup().lookup(TrendingService.class);
            if (trending == null) {
                return;
            }
            trending.show(path);
        }
    }

    private Object getFormattedValue(Channel channel, Field field) {
        switch (field) {
            case DESCR: {
                return channel.getDescription();
            }
            case VALUE: {
                double d = channel.getValue();
                if (Double.isNaN(d)) {
                    return new ValueHolder("", Color.WHITE, channel);
                }
                Color c = channel.isOnline() ? (channel.isGood() ? COLOR_GOOD : COLOR_ERR) : COLOR_OFF;
                return new ValueHolder(String.format(channel.getFormat(), d), c, channel);
            }
            case UNITS: {
                return channel.getUnits();
            }
            case LOW: {
                double d = channel.getLowLimit();
                if (Double.isNaN(d)) {
                    return new LimitHolder("", Color.BLACK, channel);
                }
                Color c = channel.isLowLimitChanged() ? Color.BLUE : Color.BLACK;
                return new LimitHolder(String.format(channel.getFormat(), d), c, channel);
            }
            case ALERT_LOW: {
                String s = channel.getLowAlarm();
                return s == null || s.isEmpty() ? new AlarmHolder(null) : new AlarmHolder(s);
            }
            case HIGH: {
                double d = channel.getHighLimit();
                if (Double.isNaN(d)) {
                    return new LimitHolder("", Color.BLACK, channel);
                }
                Color c = channel.isHighLimitChanged() ? Color.BLUE : Color.BLACK;
                return new LimitHolder(String.format(channel.getFormat(), d), c, channel);
            }
            case ALERT_HIGH: {
                String s = channel.getHighAlarm();
                return s == null || s.isEmpty() ? new AlarmHolder(null) : new AlarmHolder(s);
            }
            case NAME: {
                return channel.getName();
            }
        }
        return "";
    }

    private static String[] getPath(String displayPath) {
        int i = displayPath.indexOf("//");
        if (i != -1) {
            displayPath = displayPath.substring(i + 2);
        }
        return displayPath.split("/");
    }

    private static String getPath(DataNode node, DataNodeLeaf leaf) {
        StringBuilder sb = new StringBuilder(leaf.name);
        DataNode parent = leaf.parent;
        while (parent != null) {
            if (parent == node) {
                return sb.toString();
            }
            sb.insert(0, "/").insert(0, parent.name);
            parent = parent.parent;
        }
        return null;
    }

    private void buildDataTree(Map<String, Channel> channels) {
        this.path2data.clear();
        this.dataRoot = new DataNode("root");
        for (Map.Entry<String, Channel> e : channels.entrySet()) {
            String[] path = DataTree.getPath(e.getKey());
            DataNode parent = this.dataRoot;
            for (int level = 0; level < path.length - 1; ++level) {
                parent = parent.addChild(path[level]);
            }
            DataNodeLeaf leaf = parent.addLeaf(path[path.length - 1], e.getValue());
            this.path2data.put(e.getKey(), leaf);
        }
        for (DataNodeLeaf leaf : this.path2data.values()) {
            int depth = 0;
            DataNode node = leaf.parent;
            while (node != null) {
                if (node.depth < ++depth) {
                    node.depth = depth;
                }
                node = node.parent;
            }
        }
    }

    private DefaultMutableTreeNode buildTreeModel(DataNode dataNode, boolean start) {
        DefaultMutableTreeNode node;
        DefaultMutableTreeNode parent = null;
        if (start) {
            node = dataNode.modelNode;
            if (node == null) {
                dataNode.modelNode = node = new DefaultMutableTreeNode(dataNode);
            } else {
                parent = (DefaultMutableTreeNode)node.getParent();
                node.removeAllChildren();
            }
        } else {
            dataNode.modelNode = node = new DefaultMutableTreeNode(dataNode);
        }
        if (dataNode.leaves != null) {
            node.add(this.createLeavesNode(dataNode));
        }
        if (dataNode.children != null) {
            if (dataNode.flatten) {
                node.add(this.createDeepNode(dataNode));
            } else {
                for (DataNode child : dataNode.children) {
                    node.add(this.buildTreeModel(child, false));
                }
            }
        }
        if (parent != null) {
            this.getTreeModel().nodeStructureChanged(parent);
        }
        return node;
    }

    private DefaultMutableTreeNode createLeavesNode(DataNode node) {
        DefaultMutableTreeNode treeModelNode;
        TableModelLeaves model = new TableModelLeaves(node);
        int i = 0;
        while (i < node.leaves.size()) {
            DataNodeLeaf leaf = node.leaves.get(i);
            leaf.id = i++;
            leaf.model = model;
        }
        model.treeModelNode = treeModelNode = new DefaultMutableTreeNode(new TableHolder(model));
        return treeModelNode;
    }

    private DefaultMutableTreeNode createDeepNode(DataNode node) {
        DefaultMutableTreeNode treeModelNode;
        TableModelDeep model = new TableModelDeep(node);
        node.appendLeaves(new ArrayList<DataNodeLeaf>()).forEach(leaf -> {
            leaf.model = model;
        });
        model.treeModelNode = treeModelNode = new DefaultMutableTreeNode(new TableHolder(model));
        return treeModelNode;
    }

    private DefaultTreeModel getTreeModel() {
        return (DefaultTreeModel)this.tree.getModel();
    }

    class TableModelDeep
    extends AnyTableModel {
        private Object[][] data;
        private HashMap<String, int[]> path2cell;
        private int nValueCols;
        private ArrayList<ArrayList<DataNodeLeaf>> rows;

        TableModelDeep(DataNode node) {
            super(node);
            ArrayList<DataNodeLeaf> leaves = new ArrayList<DataNodeLeaf>();
            ArrayList<DataNodeLeaf> leaves3 = new ArrayList<DataNodeLeaf>();
            for (DataNodeLeaf leaf : node.appendLeaves(new ArrayList<DataNodeLeaf>())) {
                String[] path = DataTree.getPath(node, leaf).split("/");
                if (path.length == 2) {
                    leaves.add(leaf);
                    continue;
                }
                if (path.length != 3) continue;
                leaves3.add(leaf);
            }
            leaves.addAll(leaves3);
            ArrayList<String> rowNames = new ArrayList<String>();
            ArrayList<String> columnNames = new ArrayList<String>();
            this.path2cell = new LinkedHashMap<String, int[]>();
            this.rows = new ArrayList();
            this.rows.add(null);
            String currentSection = "";
            int currentRow = 1;
            int currentColumn = 1;
            for (DataNodeLeaf leaf : leaves) {
                int iColumn;
                int iRow;
                String column;
                String row;
                String section;
                String path = DataTree.getPath(node, leaf);
                String[] sPath = path.split("/");
                if (sPath.length == 2) {
                    section = "";
                    row = node.flip ? sPath[1] : sPath[0];
                    column = node.flip ? sPath[0] : sPath[1];
                } else {
                    section = sPath[0];
                    row = node.flip ? sPath[2] : sPath[1];
                    row = row + "/" + section;
                    String string = column = node.flip ? sPath[1] : sPath[2];
                }
                if (!section.equals(currentSection)) {
                    rowNames.add(section);
                    this.rows.add(null);
                    ++currentRow;
                    currentSection = section;
                }
                if ((iRow = rowNames.indexOf(row) + 1) == 0) {
                    iRow = currentRow++;
                    rowNames.add(row);
                    this.rows.add(new ArrayList());
                }
                if ((iColumn = columnNames.indexOf(column) + 1) == 0) {
                    iColumn = currentColumn++;
                    columnNames.add(column);
                }
                this.path2cell.put(path, new int[]{iRow, iColumn});
                this.rows.get(iRow).add(leaf);
            }
            this.nValueCols = columnNames.size();
            int nRows = this.rows.size();
            int nColumns = node.compact ? this.nValueCols + 1 : this.nValueCols + NFIELDS - 2;
            this.data = new Object[nRows][];
            for (int ir = 0; ir < nRows; ++ir) {
                int ic;
                this.data[ir] = new Object[nColumns];
                if (ir == 0) {
                    this.data[0][0] = "";
                    for (ic = 0; ic < this.nValueCols; ++ic) {
                        this.data[0][ic + 1] = columnNames.get(ic);
                    }
                    if (node.compact) continue;
                    for (ic = 2; ic < NFIELDS - 1; ++ic) {
                        this.data[0][ic + this.nValueCols - 1] = Field.values()[ic];
                    }
                    continue;
                }
                if (this.rows.get(ir) == null) {
                    this.data[ir][0] = "<html><b> " + (String)rowNames.get(ir - 1) + "</b>";
                    for (ic = 1; ic < nColumns; ++ic) {
                        this.data[ir][ic] = "";
                    }
                    continue;
                }
                this.data[ir][0] = ((String)rowNames.get(ir - 1)).split("/")[0];
                if (node.compact) continue;
                for (int i = 2; i < NFIELDS - 1; ++i) {
                    Field f = Field.values()[i];
                    Object newContent = null;
                    for (DataNodeLeaf dl : this.rows.get(ir)) {
                        Object c = DataTree.this.getFormattedValue(dl.channel, f);
                        if (newContent == null) {
                            newContent = c;
                            continue;
                        }
                        if (newContent.equals(c)) continue;
                        newContent = DataTree.MULTI_VALUE;
                        break;
                    }
                    this.data[ir][this.fieldToColumn((Field)f)] = newContent;
                }
            }
            for (DataNodeLeaf leaf : leaves) {
                int[] cell = this.path2cell.get(DataTree.getPath(node, leaf));
                this.data[cell[0]][cell[1]] = DataTree.this.getFormattedValue(leaf.channel, Field.VALUE);
            }
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public int getColumnCount() {
            return this.node.compact ? this.nValueCols + 1 : this.nValueCols + NFIELDS - 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.data[rowIndex][columnIndex];
        }

        @Override
        void update(DataNodeLeaf leaf, Field field) {
            int[] cell = this.path2cell.get(DataTree.getPath(this.node, leaf));
            if (field == null && !this.node.compact) {
                this.data[cell[0]][cell[1]] = DataTree.this.getFormattedValue(leaf.channel, Field.VALUE);
                for (int i = 2; i < NFIELDS - 1; ++i) {
                    Field f = Field.values()[i];
                    if (!f.isUpdatable()) continue;
                    Object newContent = null;
                    for (DataNodeLeaf dl : this.rows.get(cell[0])) {
                        Object c = DataTree.this.getFormattedValue(dl.channel, f);
                        if (newContent == null) {
                            newContent = c;
                            continue;
                        }
                        if (newContent.equals(c)) continue;
                        newContent = DataTree.MULTI_VALUE;
                        break;
                    }
                    this.data[cell[0]][this.fieldToColumn((Field)f)] = newContent;
                }
                this.fireTableRowsUpdated(cell[0], cell[0]);
            } else if (field == Field.VALUE || field == null && this.node.compact) {
                this.data[cell[0]][cell[1]] = DataTree.this.getFormattedValue(leaf.channel, Field.VALUE);
                this.fireTableCellUpdated(cell[0], cell[1]);
            } else if (field != Field.VALUE && !this.node.compact) {
                Object newContent = null;
                for (DataNodeLeaf dl : this.rows.get(cell[0])) {
                    Object c = DataTree.this.getFormattedValue(dl.channel, field);
                    if (newContent == null) {
                        newContent = c;
                        continue;
                    }
                    if (newContent.equals(c)) continue;
                    newContent = DataTree.MULTI_VALUE;
                    break;
                }
                cell[1] = this.fieldToColumn(field);
                this.data[cell[0]][cell[1]] = newContent;
                this.fireTableCellUpdated(cell[0], cell[1]);
            }
            ((DefaultTreeModel)DataTree.this.tree.getModel()).nodeChanged(this.treeModelNode);
        }

        private int fieldToColumn(Field field) {
            return field.ordinal() + this.nValueCols - 1;
        }

        private Field columnToField(int columnIndex) {
            return Field.values()[columnIndex - this.nValueCols + 1];
        }
    }

    class TableModelLeaves
    extends AnyTableModel {
        TableModelLeaves(DataNode node) {
            super(node);
        }

        @Override
        public int getRowCount() {
            return this.node.leaves.size();
        }

        @Override
        public int getColumnCount() {
            return this.node.compact ? 2 : NFIELDS;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            DataNodeLeaf leaf = this.node.leaves.get(rowIndex);
            return columnIndex == 0 ? leaf.name : DataTree.this.getFormattedValue(leaf.channel, Field.values()[columnIndex]);
        }

        @Override
        public String getColumnName(int column) {
            return Field.values()[column].toString();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == Field.HIGH.ordinal() || columnIndex == Field.LOW.ordinal();
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == Field.HIGH.ordinal() || columnIndex == Field.LOW.ordinal()) {
                try {
                    double oldValue;
                    double newValue = Double.parseDouble(aValue.toString());
                    DataNodeLeaf leaf = this.node.leaves.get(rowIndex);
                    Channel channel = leaf.channel;
                    boolean isHigh = columnIndex == Field.HIGH.ordinal();
                    double d = oldValue = isHigh ? channel.getHighLimit() : channel.getLowLimit();
                    if (Double.isNaN(oldValue) || Math.abs(oldValue - newValue) > 1.0E-5) {
                        String target = isHigh ? "limitHi" : "limitLo";
                        DataTree.this.sender.sendCommand(channel.getSubsystemName(), channel.getName(), "change", target, newValue);
                    }
                }
                catch (NumberFormatException x) {
                    return;
                }
                super.setValueAt(this.getValueAt(rowIndex, columnIndex), rowIndex, columnIndex);
            } else {
                super.setValueAt(aValue, rowIndex, columnIndex);
            }
        }

        @Override
        void update(DataNodeLeaf leaf, Field field) {
            if (field == null) {
                this.fireTableRowsUpdated(leaf.id, leaf.id);
            } else {
                this.fireTableCellUpdated(leaf.id, field.ordinal());
            }
            DataTree.this.getTreeModel().nodeChanged(this.treeModelNode);
        }
    }

    abstract class AnyTableModel
    extends AbstractTableModel {
        protected final DataNode node;
        protected DefaultMutableTreeNode treeModelNode;

        AnyTableModel(DataNode node) {
            this.node = node;
        }

        abstract void update(DataNodeLeaf var1, Field var2);
    }

    class AlarmHolder {
        String name;

        AlarmHolder(String name) {
            this.name = name;
        }

        String getText() {
            return this.name == null ? "" : "  \u2713";
        }
    }

    class LimitHolder {
        String value;
        Color color;
        Channel channel;

        LimitHolder(String value, Color color, Channel channel) {
            this.value = value;
            this.color = color;
            this.channel = channel;
        }

        public String toString() {
            return this.value;
        }
    }

    class ValueHolder {
        String value;
        Color color;
        Channel channel;

        ValueHolder(String value, Color color, Channel channel) {
            this.value = value;
            this.color = color;
            this.channel = channel;
        }
    }

    class TableRenderer
    extends DefaultTableCellRenderer {
        TableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground(Color.WHITE);
            this.setForeground(Color.BLACK);
            if (column == 0) {
                super.getTableCellRendererComponent(table, value, false, false, row, column);
                this.setHorizontalAlignment(2);
            } else if (row == 0 && table.getModel() instanceof TableModelDeep) {
                super.getTableCellRendererComponent(table, value, false, false, row, column);
                this.setHorizontalAlignment(0);
            } else if (value instanceof ValueHolder) {
                ValueHolder vh = (ValueHolder)value;
                super.getTableCellRendererComponent(table, vh.value, false, false, row, column);
                this.setBackground(vh.color);
                this.setHorizontalAlignment(4);
            } else if (value instanceof LimitHolder) {
                LimitHolder vh = (LimitHolder)value;
                super.getTableCellRendererComponent(table, vh.value, false, false, row, column);
                this.setForeground(vh.color);
                this.setHorizontalAlignment(4);
            } else if (value instanceof AlarmHolder) {
                AlarmHolder ah = (AlarmHolder)value;
                super.getTableCellRendererComponent(table, ah.getText(), false, false, row, column);
                this.setHorizontalAlignment(0);
            } else {
                if (DataTree.MULTI_VALUE.equals(value)) {
                    value = "";
                    this.setBackground(Color.LIGHT_GRAY);
                }
                super.getTableCellRendererComponent(table, value, false, false, row, column);
                this.setHorizontalAlignment(0);
            }
            return this;
        }
    }

    class DataNodeLeaf {
        final String name;
        Channel channel;
        DataNode parent;
        int id;
        AnyTableModel model;

        DataNodeLeaf(String name, Channel channel) {
            this.name = name;
            this.channel = channel;
        }

        void update(Channel channel, Field field) {
            if (channel != null) {
                this.channel = channel;
            }
            this.model.update(this, field);
        }
    }

    class DataNode {
        final String name;
        DataNode parent;
        boolean compact;
        boolean flatten;
        boolean flip;
        int depth;
        ArrayList<DataNodeLeaf> leaves;
        ArrayList<DataNode> children;
        DefaultMutableTreeNode modelNode;

        DataNode(String name) {
            this.name = name;
        }

        void setCompact(boolean compact) {
            if (compact == this.compact) {
                return;
            }
            this.compact = compact;
            DataTree.this.tree.saveExpansionState(0);
            DataTree.this.buildTreeModel(this, true);
            DataTree.this.tree.restoreExpanstionState(0);
        }

        void setFlatten(boolean flatten) {
            if (flatten == this.flatten) {
                return;
            }
            this.flatten = flatten;
            DataTree.this.buildTreeModel(this, true);
            DataTree.this.tree.expandPath(new TreePath(this.modelNode.getPath()));
        }

        void setFlipped(boolean flip) {
            if (flip == this.flip) {
                return;
            }
            this.flip = flip;
            DataTree.this.tree.saveExpansionState(0);
            DataTree.this.buildTreeModel(this, true);
            DataTree.this.tree.restoreExpanstionState(0);
        }

        DataNode addChild(String name) {
            if (this.children == null) {
                this.children = new ArrayList(1);
            }
            for (DataNode child : this.children) {
                if (!child.name.equals(name)) continue;
                return child;
            }
            DataNode newChild = new DataNode(name);
            newChild.parent = this;
            this.children.add(newChild);
            return newChild;
        }

        DataNodeLeaf addLeaf(String name, Channel channel) {
            if (this.leaves == null) {
                this.leaves = new ArrayList(1);
            }
            DataNodeLeaf leaf = new DataNodeLeaf(name, channel);
            this.leaves.add(leaf);
            leaf.parent = this;
            return leaf;
        }

        List<DataNodeLeaf> appendLeaves(List<DataNodeLeaf> out) {
            if (out == null) {
                out = new ArrayList<DataNodeLeaf>();
            }
            if (this.leaves != null) {
                out.addAll(this.leaves);
            }
            if (this.children != null) {
                for (DataNode child : this.children) {
                    child.appendLeaves(out);
                }
            }
            return out;
        }

        public String toString() {
            return this.name;
        }
    }

    class TableHolder {
        private final JPanel renderPanel;
        private final JPanel editPanel;

        TableHolder(AnyTableModel model) {
            JTable table = DataTree.this.createTable(model);
            this.renderPanel = new JPanel(new BorderLayout());
            this.renderPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            if (model instanceof TableModelLeaves) {
                this.renderPanel.add((Component)table.getTableHeader(), "North");
            }
            this.renderPanel.add((Component)table, "Center");
            table = DataTree.this.createTable(model);
            this.editPanel = new JPanel(new BorderLayout());
            this.editPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            if (model instanceof TableModelLeaves) {
                this.editPanel.add((Component)table.getTableHeader(), "North");
            }
            this.editPanel.add((Component)table, "Center");
        }

        JPanel getComponent(boolean editable) {
            return editable ? this.editPanel : this.renderPanel;
        }
    }

    final class NodePanel
    extends Box {
        private final JLabel label;
        private JCheckBox compact;
        private JCheckBox flatten;
        private JCheckBox flip;
        private DataNode node;

        NodePanel() {
            super(0);
            this.label = new JLabel();
            this.add(this.label);
            this.compact = new JCheckBox();
            this.compact.setToolTipText("Compact");
            this.compact.setOpaque(false);
            this.compact.addActionListener(e -> {
                if (this.node != null) {
                    this.node.setCompact(this.compact.isSelected());
                }
            });
            this.add(this.compact);
            this.flatten = new JCheckBox();
            this.flatten.setToolTipText("Flatten");
            this.flatten.setOpaque(false);
            this.flatten.addActionListener(e -> {
                if (this.node != null) {
                    boolean selected = this.flatten.isSelected();
                    this.flip.setEnabled(selected);
                    this.node.setFlatten(selected);
                }
            });
            this.add(this.flatten);
            this.flip = new JCheckBox();
            this.flip.setToolTipText("Flip");
            this.flip.setOpaque(false);
            this.flip.addActionListener(e -> {
                if (this.node != null) {
                    this.node.setFlipped(this.flip.isSelected());
                }
            });
            this.add(this.flip);
            this.add(Box.createRigidArea(new Dimension(20, 0)));
            this.add(Box.createHorizontalGlue());
        }

        void setNode(DataNode node) {
            this.node = null;
            if (node != null) {
                this.label.setText(" " + node.name + " ");
                this.compact.setSelected(node.compact);
                this.compact.setEnabled(node.modelNode.getLeafCount() > 0);
                this.flatten.setSelected(node.flatten);
                this.flip.setSelected(node.flip);
                this.flatten.setEnabled(node.depth == 2 || node.depth == 3);
                this.flip.setEnabled(node.flatten);
                this.node = node;
            }
        }
    }

    class TreeEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        private final TreeRenderer renderer;
        private Object editorValue;
        private Component component;

        public TreeEditor() {
            this.renderer = new TreeRenderer(true);
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            this.editorValue = value;
            return this.renderer.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, true);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            this.editorValue = null;
            if (anEvent instanceof MouseEvent) {
                this.redirect((MouseEvent)anEvent);
            }
            return false;
        }

        private void redirect(MouseEvent anEvent) {
            SwingUtilities.invokeLater(() -> {
                try {
                    MouseEvent ev = SwingUtilities.convertMouseEvent(anEvent.getComponent(), anEvent, this.component);
                    this.component.dispatchEvent(ev);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }

        @Override
        public Object getCellEditorValue() {
            return this.editorValue;
        }
    }

    class TreeRenderer
    extends DefaultTreeCellRenderer {
        private final NodePanel nodePanel;
        private final boolean editable;

        TreeRenderer(boolean editable) {
            this.nodePanel = new NodePanel();
            this.editable = editable;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
            Object payload = treeNode.getUserObject();
            if (payload instanceof JComponent) {
                return (JComponent)payload;
            }
            if (payload instanceof TableHolder) {
                return ((TableHolder)payload).getComponent(this.editable);
            }
            if (payload instanceof DataNode) {
                this.nodePanel.setNode((DataNode)payload);
                return this.nodePanel;
            }
            return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        }
    }

    class Tree
    extends JTree
    implements MonitorDisplay {
        private String expansionState;

        Tree() {
        }

        @Override
        public void saveData(OutputStream out, String mimeType) {
            if (DataTree.this.dataRoot != null) {
                List<DataNodeLeaf> leaves = DataTree.this.dataRoot.appendLeaves(new ArrayList<DataNodeLeaf>());
                ArrayList<Channel> channels = new ArrayList<Channel>(leaves.size());
                leaves.forEach(leaf -> channels.add(leaf.channel));
                LsstMonitorPlugin.saveData(out, mimeType, channels);
            }
        }

        private boolean isDescendant(TreePath path1, TreePath path2) {
            int count2;
            int count1 = path1.getPathCount();
            if (count1 <= (count2 = path2.getPathCount())) {
                return false;
            }
            while (count1 != count2) {
                path1 = path1.getParentPath();
                --count1;
            }
            return path1.equals(path2);
        }

        void saveExpansionState(int row) {
            TreePath rowPath = this.getPathForRow(row);
            StringBuilder sb = new StringBuilder();
            int rowCount = this.getRowCount();
            for (int i = row; i < rowCount; ++i) {
                TreePath path = this.getPathForRow(i);
                if (i != row && !this.isDescendant(path, rowPath)) break;
                if (!this.isExpanded(path)) continue;
                sb.append(",").append(i - row);
            }
            this.expansionState = sb.toString();
        }

        void restoreExpanstionState(int row) {
            StringTokenizer stok = new StringTokenizer(this.expansionState, ",");
            while (stok.hasMoreTokens()) {
                int token = row + Integer.parseInt(stok.nextToken());
                DataTree.this.tree.expandRow(token);
            }
        }
    }
}

