/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.monitor;

import org.lsst.ccs.framework.ConfigurableComponent;
import org.lsst.ccs.subsystem.monitor.Device;
import org.lsst.ccs.subsystem.monitor.Monitor;

public class Line
extends ConfigurableComponent {
    private String devcName;
    private int chan;
    private String compDevcName;
    private int compChan;
    private Device device;
    private Device compDevice;

    public Line() {
    }

    @Deprecated
    public Line(String devcName, int chan, String devcNameC, int chanC) {
        this.devcName = devcName;
        this.chan = chan;
        this.compDevcName = devcNameC;
        this.compChan = chanC;
    }

    void configure(Monitor mon) {
        try {
            if (this.devcName != null) {
                this.device = mon.getDevice(this.devcName);
                if (this.device == null) {
                    mon.reportError(this.getName(), "device", this.devcName);
                }
                this.device.checkLine(this.getName(), this.chan);
            }
            if (this.compDevcName != null) {
                this.compDevice = mon.getDevice(this.compDevcName);
                if (this.compDevice == null) {
                    mon.reportError(this.getName(), "device", this.compDevcName);
                }
                this.compDevice.checkLine(this.getName(), this.compChan);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setWarm(boolean on) {
        if (this.device != null) {
            this.device.setLineWarm(this.chan, on);
        }
        if (this.compDevice != null) {
            this.compDevice.setLineWarm(this.compChan, !on);
        }
    }

    public void set(boolean on) {
        if (this.device != null && this.device.online) {
            this.device.setLine(this.chan, on);
        }
        if (this.compDevice != null && this.compDevice.online) {
            this.compDevice.setLine(this.compChan, !on);
        }
    }

    public boolean isSet() {
        boolean state = false;
        if (this.device != null && this.device.online) {
            state = this.device.isLineSet(this.chan);
        } else if (this.compDevice != null && this.compDevice.online) {
            state = !this.compDevice.isLineSet(this.compChan);
        }
        return state;
    }
}

