/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.studio;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.freehep.application.studio.LibInfo;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.PluginDir;
import org.freehep.application.studio.Studio;
import org.freehep.util.VersionComparator;
import org.jdom.Element;

public class PluginInfo
implements Comparable<PluginInfo> {
    private static final String[] NOCATEGORY = new String[0];
    private final String name;
    private final String author;
    private final String version;
    private final String mainClass;
    private String title;
    private String description;
    private final String category;
    private final boolean defaultLoadAtStart;
    private final Map<String, String> properties;
    private final String[] j2se;
    private final String[] appVersion;
    private final Map<String, String[]> depends;
    private ArrayList<LibInfo> files;
    private Throwable errorStatus;
    private Plugin plugin;
    private PluginDir directory;
    private boolean loadAtStart;

    public PluginInfo(String name, String author, String version, String mainClass, String title, String description, String category, boolean defaultLoadAtStart) {
        this(name, author, version, mainClass, title, description, category, defaultLoadAtStart, null, null, null, null);
    }

    public PluginInfo(String name, String author, String version, String mainClass, String title, String description, String category, boolean defaultLoadAtStart, Map<String, String> properties, String[] j2se, String[] appVersion, Map<String, String[]> depends) {
        this.name = name;
        this.author = author;
        this.version = version;
        this.mainClass = mainClass;
        this.title = title;
        this.description = description;
        this.category = category;
        this.defaultLoadAtStart = defaultLoadAtStart;
        this.loadAtStart = defaultLoadAtStart;
        this.properties = properties;
        this.j2se = j2se;
        this.appVersion = appVersion;
        this.depends = depends;
    }

    public PluginInfo(Element node) {
        Element info = node.getChild("information");
        this.name = info.getChildTextNormalize("name");
        this.author = info.getChildTextNormalize("author");
        this.category = info.getChildTextNormalize("category");
        String version = this.verifyVersion(info.getChildTextNormalize("version"));
        this.version = version == null ? "1.0.0" : version;
        this.loadAtStart = info.getChild("load-at-start") != null;
        this.defaultLoadAtStart = this.loadAtStart;
        Element pluginDescription = node.getChild("plugin-desc");
        this.mainClass = pluginDescription == null ? null : pluginDescription.getAttributeValue("class");
        List desc = info.getChildren("description");
        for (Element d : desc) {
            String type = d.getAttributeValue("type");
            String text = d.getTextNormalize();
            if (type != null && type.equals("short")) {
                this.title = text;
                continue;
            }
            this.description = text;
        }
        String[] j2se = null;
        String[] appVersion = null;
        HashMap<String, String[]> depends = null;
        HashMap<String, String> properties = null;
        Element resources = node.getChild("resources");
        if (resources != null) {
            List propList;
            List fileList;
            List depList;
            String maxVersion;
            String minVersion;
            Element e = resources.getChild("j2se");
            if (e != null) {
                minVersion = this.verifyVersion(e.getAttributeValue("minVersion"));
                maxVersion = this.verifyVersion(e.getAttributeValue("maxVersion"));
                if (minVersion != null || maxVersion != null) {
                    j2se = new String[]{minVersion, maxVersion};
                }
            }
            if ((e = resources.getChild("application")) != null) {
                minVersion = this.verifyVersion(e.getAttributeValue("minVersion"));
                maxVersion = this.verifyVersion(e.getAttributeValue("maxVersion"));
                if (minVersion != null || maxVersion != null) {
                    appVersion = new String[]{minVersion, maxVersion};
                }
            }
            if (!(depList = resources.getChildren("depends")).isEmpty()) {
                depends = new HashMap<String, String[]>();
                for (Element f : depList) {
                    String[] stringArray;
                    String plug = f.getAttributeValue("plugin");
                    String minVersion2 = this.verifyVersion(f.getAttributeValue("minVersion"));
                    String maxVersion2 = this.verifyVersion(f.getAttributeValue("maxVersion"));
                    if (minVersion2 == null && maxVersion2 == null) {
                        stringArray = null;
                    } else {
                        String[] stringArray2 = new String[2];
                        stringArray2[0] = minVersion2;
                        stringArray = stringArray2;
                        stringArray2[1] = maxVersion2;
                    }
                    String[] v = stringArray;
                    depends.put(plug, v);
                }
            }
            if (!(fileList = resources.getChildren("file")).isEmpty()) {
                this.files = new ArrayList(fileList.size());
                for (Element f : fileList) {
                    String href = f.getAttributeValue("href");
                    String location = f.getAttributeValue("location");
                    this.files.add(new LibInfo(location, href));
                }
            }
            if (!(propList = resources.getChildren("property")).isEmpty()) {
                properties = new HashMap<String, String>();
                for (Element f : propList) {
                    String propertyName = f.getAttributeValue("name");
                    String value = f.getAttributeValue("value");
                    properties.put(propertyName, value);
                }
            }
        }
        this.j2se = j2se;
        this.appVersion = appVersion;
        this.depends = depends;
        this.properties = properties;
    }

    public PluginInfo(PluginInfo original) {
        this.name = original.name;
        this.author = original.author;
        this.version = original.version;
        this.mainClass = original.mainClass;
        this.title = original.title;
        this.description = original.description;
        this.category = original.category;
        this.defaultLoadAtStart = original.defaultLoadAtStart;
        this.properties = original.properties;
        this.j2se = original.j2se;
        this.appVersion = original.appVersion;
        this.depends = original.depends;
        this.files = new ArrayList(original.files.size());
        for (LibInfo lib : original.files) {
            this.files.add(new LibInfo(lib));
        }
        this.errorStatus = original.errorStatus;
        this.directory = original.directory;
        this.loadAtStart = original.loadAtStart;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getVersion() {
        return this.version;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    @Deprecated
    public String[] getCategory() {
        return this.category == null ? NOCATEGORY : this.category.split("\\.");
    }

    public List<String[]> getCategories() {
        if (this.category != null) {
            String[] tokens = this.category.split("\\,", -1);
            ArrayList<String[]> out = new ArrayList<String[]>(tokens.length);
            for (String token : tokens) {
                String[] cat = token.trim().split("\\.");
                if (cat.length == 1 && cat[0].isEmpty()) {
                    cat = NOCATEGORY;
                }
                if (out.contains(cat)) continue;
                out.add(cat);
            }
            return out;
        }
        return null;
    }

    public Map<String, String> getProperties() {
        return this.properties == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(this.properties);
    }

    public String getJavaMinVersion() {
        return this.j2se == null ? null : this.j2se[0];
    }

    public String getJavaMaxVersion() {
        return this.j2se == null ? null : this.j2se[1];
    }

    public String getApplicationMinVersion() {
        return this.appVersion == null ? null : this.appVersion[0];
    }

    public String getApplicationMaxVersion() {
        return this.appVersion == null ? null : this.appVersion[1];
    }

    public Set<String> getRequiredPluginNames() {
        return this.depends == null ? Collections.emptySet() : Collections.unmodifiableSet(this.depends.keySet());
    }

    public String getRequiredPluginMinVersion(String pluginName) {
        if (this.depends == null) {
            return null;
        }
        String[] ver = this.depends.get(pluginName);
        return ver == null ? null : ver[0];
    }

    public String getRequiredPluginMaxVersion(String pluginName) {
        if (this.depends == null) {
            return null;
        }
        String[] ver = this.depends.get(pluginName);
        return ver == null ? null : ver[1];
    }

    public List<LibInfo> getLibraries() {
        return this.files == null ? Collections.emptyList() : Collections.unmodifiableList(this.files);
    }

    public boolean isLoadAtStart() {
        return this.loadAtStart;
    }

    public boolean hasMainClass() {
        return this.mainClass != null;
    }

    public PluginDir getDirectory() {
        return this.directory;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public Throwable getErrorStatus() {
        return this.errorStatus;
    }

    public boolean isApplicationCompatible(Studio app) {
        if (this.appVersion == null) {
            return true;
        }
        String currentVersion = app.getVersion();
        if (currentVersion == null) {
            return true;
        }
        try {
            String minVersion = this.appVersion[0];
            if (minVersion != null && VersionComparator.compareVersion((String)minVersion, (String)currentVersion) > 0) {
                return false;
            }
            String maxVersion = this.appVersion[1];
            if (maxVersion != null && VersionComparator.compareVersion((String)maxVersion, (String)currentVersion) < 0) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return true;
    }

    public boolean isJavaCompatible() {
        if (this.appVersion == null) {
            return true;
        }
        String currentVersion = System.getProperty("java.version");
        if (currentVersion == null) {
            return true;
        }
        try {
            String minVersion = this.j2se[0];
            if (minVersion != null && VersionComparator.compareVersion((String)minVersion, (String)currentVersion) > 0) {
                return false;
            }
            String maxVersion = this.j2se[1];
            if (maxVersion != null && VersionComparator.compareVersion((String)maxVersion, (String)currentVersion) < 0) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return true;
    }

    public boolean isRequiredPluginValid(PluginInfo required) {
        if (required == null) {
            return false;
        }
        String min = this.getRequiredPluginMinVersion(required.getName());
        String max = this.getRequiredPluginMaxVersion(required.getName());
        return !(min != null && VersionComparator.compareVersion((String)min, (String)required.getVersion()) > 0 || max != null && VersionComparator.compareVersion((String)max, (String)required.getVersion()) < 0);
    }

    public void setDirectory(PluginDir directory) {
        this.directory = directory;
        if (this.files != null) {
            for (LibInfo lib : this.files) {
                lib.setDir(directory);
            }
        }
    }

    public void setLoadAtStart(boolean loadAtStart) {
        this.loadAtStart = loadAtStart;
    }

    void setErrorStatus(Throwable t) {
        this.errorStatus = t;
    }

    void setPlugin(Plugin plugin) {
        this.plugin = plugin;
    }

    public void setLibraries(ArrayList<LibInfo> libraries) {
        this.files = libraries;
        this.setDirectory(this.getDirectory());
    }

    void loadUserProperties(Properties user) {
        String prop = user.getProperty("loadAtStart." + this.name);
        if (prop != null) {
            this.loadAtStart = Boolean.valueOf(prop);
        }
    }

    void saveUserProperties(Properties user) {
        String key = "loadAtStart." + this.name;
        if (this.loadAtStart == this.defaultLoadAtStart) {
            user.remove(key);
        } else {
            user.setProperty(key, String.valueOf(this.loadAtStart));
        }
    }

    private String verifyVersion(String version) {
        if (version == null) {
            return null;
        }
        try {
            return VersionComparator.getVersion((String)version).toString();
        }
        catch (IllegalArgumentException x) {
            return null;
        }
    }

    @Override
    public int compareTo(PluginInfo o) {
        return this.name.compareTo(o.name);
    }

    public boolean equals(Object o) {
        if (o instanceof PluginInfo) {
            return this.name.equals(((PluginInfo)o).name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

