/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandReply;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.LogMessage;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.messaging.AgentPresenceManager;
import org.lsst.ccs.messaging.BusApplicationLayer;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.BusMessagingLayer;
import org.lsst.ccs.messaging.ClusterDeserializationErrorHandler;
import org.lsst.ccs.messaging.CommandExecutor;
import org.lsst.ccs.messaging.CommandMessageListener;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.messaging.LogMessageListener;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.utilities.logging.Logger;

public class AgentMessagingLayer {
    private static final List<AgentMessagingLayer> msgAccesses = new CopyOnWriteArrayList<AgentMessagingLayer>();
    private final Predicate<BusMessage<? extends Serializable, ?>> filterMessagesFromThisAgent;
    private final Logger curLogger = Logger.getLogger((String)"org.lsst.ccs.bus");
    private final BusApplicationLayer layer;
    private final AgentInfo agentInfo;

    public static AgentMessagingLayer createInstance(AgentInfo agentInfo) {
        AgentMessagingLayer agentMessagingLayer = new AgentMessagingLayer(agentInfo);
        msgAccesses.add(agentMessagingLayer);
        return agentMessagingLayer;
    }

    AgentMessagingLayer(AgentInfo agentInfo) {
        if (agentInfo == null) {
            throw new RuntimeException("MessagingAccess cannot have null Agent");
        }
        this.agentInfo = agentInfo;
        this.layer = new BusApplicationLayer(agentInfo);
        this.filterMessagesFromThisAgent = BusMessageFilterFactory.messageOrigin(agentInfo.getName()).negate();
    }

    public AgentInfo getAgentInfo() {
        return this.agentInfo;
    }

    public String getAgentName() {
        return this.agentInfo.getName();
    }

    protected BusApplicationLayer getApplicationLayer() {
        return this.layer;
    }

    public void shutdownBusAccess() {
        this.layer.close();
        msgAccesses.remove(this);
    }

    public AgentPresenceManager getAgentPresenceManager() {
        return this.layer.getAgentPresenceManager();
    }

    public void addLogMessageListener(LogMessageListener listener) {
        this.addLogMessageListener(listener, this.filterMessagesFromThisAgent);
    }

    public void addLogMessageListener(LogMessageListener listener, Predicate<BusMessage<? extends Serializable, ?>> filter) {
        this.layer.addLogListener(listener, filter);
    }

    public void addStatusMessageListener(StatusMessageListener listener) {
        this.addStatusMessageListener(listener, this.filterMessagesFromThisAgent);
    }

    public void addStatusMessageListener(StatusMessageListener listener, Predicate<BusMessage<? extends Serializable, ?>> filter) {
        this.layer.addStatusListener(listener, filter);
    }

    public void addCommandMessageListener(CommandMessageListener listener) {
        this.addCommandMessageListener(listener, this.filterMessagesFromThisAgent);
    }

    public void addCommandMessageListener(CommandMessageListener listener, Predicate<BusMessage<? extends Serializable, ?>> filter) {
        this.layer.addCommandListener(listener, filter);
    }

    public void removeLogMessageListener(LogMessageListener listener) {
        this.layer.removeLogListener(listener);
    }

    public void removeStatusMessageListener(StatusMessageListener listener) {
        this.layer.removeStatusListener(listener);
    }

    public void removeCommandMessageListener(CommandMessageListener listener) {
        this.layer.removeCommandListener(listener);
    }

    public void sendLogMessage(LogMessage msg) {
        msg.setOriginAgentInfo(this.getAgentInfo());
        this.layer.sendLog(msg);
    }

    public void sendStatusMessage(StatusMessage msg) {
        msg.setOriginAgentInfo(this.getAgentInfo());
        this.curLogger.finest((Object)("sending status " + msg));
        this.layer.sendStatus(msg);
    }

    public void sendCommandRequest(CommandRequest cmd, CommandOriginator originator) {
        cmd.setOriginAgentInfo(this.getAgentInfo());
        this.layer.sendCommand(cmd, originator);
    }

    public void sendCommandReply(CommandReply reply) {
        reply.setOriginAgentInfo(this.getAgentInfo());
        this.layer.reply(reply);
    }

    public void setCommandExecutor(CommandExecutor executor) {
        this.layer.setCommandExecutor(executor);
    }

    public void setClusterDeserializationErrorHandler(ClusterDeserializationErrorHandler h) {
        this.layer.setClusterDeserializationErrorHandler(h);
    }

    static List<AgentMessagingLayer> getMessagingAccesses() {
        return msgAccesses;
    }

    static void printMessagingAccessInfo(AgentMessagingLayer msgAccess) {
        System.out.println("MessagingAccess " + msgAccess.getAgentName());
        BusApplicationLayer layer = msgAccess.getApplicationLayer();
        System.out.println("BusApplicationLayer " + layer);
        BusMessagingLayer messagingLayer = layer.getBusMessagingLayer();
        System.out.println("BusMessagingLayer " + messagingLayer);
        Set<String> localAgents = messagingLayer.getRegisteredLocalAgents();
        System.out.println("Local Agents " + localAgents.size());
        for (String agent : localAgents) {
            System.out.println("\t" + agent);
        }
    }
}

