/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.Component;
import java.util.Properties;
import javax.swing.JComponent;
import org.freehep.application.Application;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.mdi.PageEvent;
import org.freehep.application.mdi.PageListener;
import org.freehep.application.mdi.PageManager;
import org.freehep.application.studio.Studio;
import org.freehep.graphicsbase.util.export.ExportDialog;
import org.freehep.graphicsbase.util.export.ExportFileType;
import org.freehep.util.commanddispatcher.CommandGroup;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.lsst.ccs.gconsole.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorDisplay;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorExport;

@Plugin(name="LSST Monitoring Plugin", id="monitor", description="LSST CCS monitoring data display service.")
public class LsstMonitorPlugin
extends ConsolePlugin {
    private final Studio app = (Studio)Application.getApplication();

    @Override
    public void initialize() {
        PageManager pm = this.app.getPageManager();
        pm.addPageListener((PageListener)new Saver());
    }

    private class Saver
    extends CommandProcessor
    implements PageListener {
        private boolean on;

        private Saver() {
        }

        public void pageChanged(PageEvent pe) {
            PageContext context = pe.getPageContext();
            if (context == null) {
                return;
            }
            JComponent panel = (JComponent)context.getPage();
            if (panel == null) {
                return;
            }
            switch (pe.getID()) {
                case 3999: {
                    MonitorDisplay md = this.findMonitorDisplay(panel, false);
                    if (md == null) {
                        if (!this.on) break;
                        LsstMonitorPlugin.this.app.getCommandTargetManager().remove((CommandGroup)this);
                        this.on = false;
                        break;
                    }
                    if (this.on) break;
                    LsstMonitorPlugin.this.app.getCommandTargetManager().add((CommandGroup)this);
                    this.on = true;
                    break;
                }
            }
        }

        private MonitorDisplay findMonitorDisplay(JComponent component, boolean visibleOnly) {
            Component[] cc;
            if (visibleOnly && !component.isShowing()) {
                return null;
            }
            if (component instanceof MonitorDisplay) {
                return (MonitorDisplay)((Object)component);
            }
            for (Component c : cc = component.getComponents()) {
                MonitorDisplay md;
                if (!(c instanceof JComponent) || (md = this.findMonitorDisplay((JComponent)c, visibleOnly)) == null) continue;
                return md;
            }
            return null;
        }

        public void onSaveAs() {
            try {
                PageManager pm = LsstMonitorPlugin.this.app.getPageManager();
                PageContext context = pm.getSelectedPage();
                JComponent component = (JComponent)context.getPage();
                MonitorDisplay md = this.findMonitorDisplay(component, true);
                Properties user = LsstMonitorPlugin.this.app.getUserProperties();
                String creator = "creator";
                ExportDialog dlg = new ExportDialog(creator, false);
                dlg.addExportFileType((ExportFileType)new MonitorExport());
                dlg.addExportFileType((ExportFileType)new MonitorExport());
                dlg.setUserProperties(user);
                dlg.showExportDialog((Component)LsstMonitorPlugin.this.app, "Save As...", (Component)((Object)md), "monitor");
            }
            catch (ClassCastException | NullPointerException x) {
                LsstMonitorPlugin.this.app.error("No selected monitoring table", (Throwable)x);
            }
        }
    }
}

