/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.dictionary;

import java.awt.Color;
import java.io.Serializable;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.gconsole.plugins.dictionary.CommandListener;
import org.lsst.ccs.gconsole.plugins.dictionary.DictionaryContext;
import org.lsst.ccs.gconsole.plugins.dictionary.DictionaryTreeMainPanel;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.utilities.logging.StackTraceFormats;
import org.lsst.ccs.utilities.structs.TreeBranch;

public class DictionaryBusMaster {
    private final DictionaryTreeMainPanel mainPanel;
    private AgentMessagingLayer messagingAccess;

    public DictionaryBusMaster(AgentMessagingLayer messaginAccess) {
        this.messagingAccess = messaginAccess;
        this.mainPanel = new DictionaryTreeMainPanel(new CommandListener(){

            @Override
            public String sendCommand(String cmd, String destination) {
                return DictionaryBusMaster.this.executeSyncInvoke(cmd, destination);
            }

            @Override
            public Object[][] getConnectedAgents() {
                return DictionaryBusMaster.this.busMasterGetConnectedAgents();
            }

            @Override
            public TreeBranch<DictionaryContext> buildDictionaryTree(String destination) {
                return DictionaryBusMaster.this.busMasterBuildDictionaryTree(destination);
            }

            @Override
            public boolean isInEngineeringMode(String destination) {
                Object res = DictionaryBusMaster.this.executeInternalSyncInvoke("isInEngineeringMode", destination);
                if (res instanceof Boolean) {
                    return (Boolean)res;
                }
                return false;
            }
        });
    }

    public DictionaryTreeMainPanel getMainPane() {
        return this.mainPanel;
    }

    public void initGUI() {
        this.messagingAccess.getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this.mainPanel);
    }

    public JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Menu");
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Refresh");
        menuItem.setBackground(Color.LIGHT_GRAY);
        menu.add(menuItem);
        return menuBar;
    }

    public Object[][] busMasterGetConnectedAgents() {
        List agentList = this.messagingAccess.getAgentPresenceManager().listConnectedAgents();
        int i = 0;
        Object[][] res = new Object[agentList.size()][1];
        for (AgentInfo a : agentList) {
            res[i][0] = a;
            ++i;
        }
        return res;
    }

    TreeBranch<DictionaryContext> busMasterBuildDictionaryTree(String destination) {
        Object systemDictionary = this.executeInternalSyncInvoke("getDictionaries", destination);
        TreeMap dictionaryMap = new TreeMap((Map)systemDictionary);
        TreeBranch dictionaryTree = null;
        if (!dictionaryMap.isEmpty()) {
            String aPath = dictionaryMap.keySet().toArray(new String[0])[0];
            String root = aPath.split("/")[0];
            Dictionary rootDictionary = (Dictionary)dictionaryMap.remove(root);
            TreeBranch treeWalker = dictionaryTree = new TreeBranch((Serializable)new DictionaryContext(root, rootDictionary));
            for (Map.Entry entry : dictionaryMap.entrySet()) {
                treeWalker = dictionaryTree;
                String[] pathTab = ((String)entry.getKey()).split("/");
                for (int i = 1; i < pathTab.length; ++i) {
                    boolean found = false;
                    if (treeWalker.getChildren() != null) {
                        Iterator it = treeWalker.getChildIterator();
                        while (it.hasNext() && !found) {
                            TreeBranch currIt = (TreeBranch)it.next();
                            if (!((DictionaryContext)currIt.getContent()).getName().equals(pathTab[i])) continue;
                            treeWalker = currIt;
                            found = true;
                            if (i != pathTab.length - 1) continue;
                            treeWalker.setContent((Serializable)new DictionaryContext(pathTab[i], (Dictionary)entry.getValue()));
                        }
                    }
                    if (found) continue;
                    treeWalker = new TreeBranch(treeWalker, (Serializable)new DictionaryContext(pathTab[i], (Dictionary)entry.getValue()));
                }
            }
        }
        return dictionaryTree;
    }

    public Object executeInternalSyncInvoke(String cmd, String destination) {
        CommandRequest cmdRequest = new CommandRequest(destination, cmd);
        try {
            return new ConcurrentMessagingUtils(this.messagingAccess).sendSynchronousCommand(cmdRequest, Duration.ofSeconds(5L));
        }
        catch (Exception e) {
            return null;
        }
    }

    public String executeSyncInvoke(String cmd, String destination) {
        CommandRequest cmdRequest = new CommandRequest(destination, cmd);
        try {
            Object res = new ConcurrentMessagingUtils(this.messagingAccess).sendSynchronousCommand(cmdRequest, Duration.ofSeconds(5L));
            String strRes = null;
            strRes = res instanceof Exception ? StackTraceFormats.toString((Throwable)((Exception)res), (int)1) : (res == null ? "ok : VOID" : String.valueOf(res));
            return strRes;
        }
        catch (Exception e) {
            return "<html> <font color=\"#FF0000\"> Exception caught : " + StackTraceFormats.toString((Throwable)e, (int)1) + "</font></html>";
        }
    }

    public void doShutdown() {
        this.messagingAccess.getAgentPresenceManager().removeAgentPresenceListener((AgentPresenceListener)this.mainPanel);
    }
}

