/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.monitor;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystem.monitor.Monitor;

public class MonitorCommands {
    private final Monitor mon;

    public MonitorCommands(Monitor mon) {
        this.mon = mon;
    }

    @Command(type=Command.CommandType.ACTION, description="Save the monitoring limits")
    public void saveLimits() throws IOException {
        this.mon.saveLimits();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of all devices")
    public List<String> getDeviceNames() {
        return this.mon.getDeviceNames();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of channel names")
    public List<String> getChannelNames() {
        return this.mon.getChannelNames();
    }

    @Command(type=Command.CommandType.QUERY, description="Get a channel value")
    public double getChannelValue(@Argument(name="name", description="Channel name") String name) {
        Double value = this.mon.getChannelValue(name);
        if (value == null) {
            throw new IllegalArgumentException("Unknown channel name: " + name);
        }
        return value;
    }

    @Command(type=Command.CommandType.QUERY, description="Read a channel value")
    public double readChannelValue(@Argument(name="name", description="Channel name") String name) {
        Double value = this.mon.readChannelValue(name);
        if (value == null) {
            throw new IllegalArgumentException("Unknown channel name: " + name);
        }
        return value;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the map of all configured values")
    public Map<String, Object> getConfigurationMap() {
        return this.mon.getConfigurationMap();
    }
}

